/*
 * Decompiled with CFR 0.152.
 */
package com.wcl102.villagermarkers.network.packets;

import com.wcl102.villagermarkers.client.ClientVillagerManager;
import com.wcl102.villagermarkers.client.resource.VillagerResource;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketVillagerData
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            EntityVillager villager = (EntityVillager)player.field_71133_b.func_71218_a(player.field_71093_bK).func_175733_a(Objects.requireNonNull(UUID.fromString(message.tag.func_74779_i("UUID"))));
            if (villager != null) {
                VillagerResource r = new VillagerResource(villager);
                return new Message(villager.func_110124_au(), r);
            }
        } else {
            ClientVillagerManager.add(UUID.fromString(message.tag.func_74779_i("UUID")), new VillagerResource(message.tag));
        }
        return null;
    }

    public static class Message
    implements IMessage {
        public NBTTagCompound tag;

        public Message() {
        }

        public Message(UUID uuid, VillagerResource resource) {
            this(uuid);
            this.tag.func_74778_a("Career", resource.getCareerName());
            this.tag.func_74768_a("CareerLevel", resource.getLevel());
        }

        public Message(UUID uuid) {
            this.tag = new NBTTagCompound();
            this.tag.func_74778_a("UUID", uuid.toString());
        }

        public void fromBytes(ByteBuf buf) {
            this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        }
    }
}

