/*
 * Decompiled with CFR 0.152.
 */
package com.wcl102.villagermarkers.client.resource;

import com.wcl102.villagermarkers.VillagerMarkersConfig;
import com.wcl102.villagermarkers.client.ClientVillagerManager;
import com.wcl102.villagermarkers.client.resource.MarkerResource;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VillagerResource {
    private final String careerName;
    private final int level;

    public VillagerResource(EntityVillager villager) {
        NBTTagCompound nbt = villager.func_189511_e(new NBTTagCompound());
        int career = nbt.func_74762_e("Career") - 1;
        this.careerName = villager.getProfessionForge().getCareer(career).getName();
        this.level = nbt.func_74762_e("CareerLevel");
    }

    public VillagerResource(NBTTagCompound tag) {
        this.careerName = tag.func_74779_i("Career");
        this.level = tag.func_74762_e("CareerLevel");
    }

    @SideOnly(value=Side.CLIENT)
    public MarkerResource getMarker() {
        String key = this.careerName + "-" + this.level;
        if (!ClientVillagerManager.hasMarker(key)) {
            ResourceLocation resource = new ResourceLocation(String.format("textures/entity/villager/markers/%s.png", this.careerName));
            MarkerResource.OverlayType overlayType = MarkerResource.OverlayType.fromValue(VillagerMarkersConfig.overlayIndex).orElse(MarkerResource.OverlayType.NONE);
            try {
                Minecraft.func_71410_x().func_110442_L().func_110536_a(resource);
            }
            catch (IOException e) {
                resource = MarkerResource.DEFAULT_ICON;
                e.printStackTrace();
            }
            ClientVillagerManager.addMarker(key, new MarkerResource(resource, overlayType, this.level));
        }
        return ClientVillagerManager.getMarker(key);
    }

    public String getCareerName() {
        return this.careerName;
    }

    public int getLevel() {
        return this.level;
    }
}

