/*
 * Decompiled with CFR 0.152.
 */
package com.wcl102.villagermarkers.client.resource;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MarkerResource {
    public static final ResourceLocation DEFAULT_ICON = new ResourceLocation("textures/entity/villager/default.png");
    public static final ResourceLocation MARKER_ARROW = new ResourceLocation("textures/entity/villager/arrow.png");
    public static final ResourceLocation ICON_OVERLAY = new ResourceLocation("textures/entity/villager/overlay.png");
    public static final ResourceLocation NUMBER_OVERLAY = new ResourceLocation("textures/entity/villager/numbers.png");
    public final ResourceLocation texture;
    public final OverlayType overlay;
    public final int level;

    public MarkerResource(ResourceLocation texture, OverlayType overlay, int level) {
        this.texture = texture;
        this.overlay = overlay;
        this.level = level;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.texture, this.overlay, this.level});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MarkerResource)) {
            return false;
        }
        MarkerResource other = (MarkerResource)obj;
        return Objects.equals(this.texture, other.texture) && Objects.equals((Object)this.overlay, (Object)other.overlay) && Objects.equals(this.level, other.level);
    }

    public static enum OverlayType {
        NONE(0),
        ICON(1),
        LEVEL(2);

        private final int value;

        private OverlayType(int value) {
            this.value = value;
        }

        public static Optional<OverlayType> fromValue(int value) {
            return Arrays.stream(OverlayType.values()).filter(v -> v.value == value).findFirst();
        }
    }
}

