/*
 * Decompiled with CFR 0.152.
 */
package com.wcl102.villagermarkers.client.render;

import com.wcl102.villagermarkers.VillagerMarkersConfig;
import com.wcl102.villagermarkers.client.resource.MarkerResource;
import com.wcl102.villagermarkers.client.resource.VillagerResource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderLivingEvent;

public class Markers {
    public static void renderMarker(RenderLivingEvent.Specials.Post<? extends EntityVillager> event, VillagerResource resource) {
        EntityLivingBase entity = event.getEntity();
        RenderManager renderManager = event.getRenderer().func_177068_d();
        double x = event.getX();
        double y = event.getY() + (double)entity.field_70131_O + 0.1;
        double z = event.getZ();
        float viewerYaw = renderManager.field_78735_i;
        float viewerPitch = renderManager.field_78732_j;
        Markers.renderMarker(resource, x, y, z, viewerYaw, viewerPitch);
    }

    public static void renderMarker(VillagerResource resource, double x, double y, double z, float viewerYaw, float viewerPitch) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)viewerPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179140_f();
        float alpha = 1.0f;
        if (VillagerMarkersConfig.fadePercent > 0.0) {
            double distance = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            double startFade = 1.0 - VillagerMarkersConfig.fadePercent / 100.0;
            alpha = (float)MathHelper.func_151237_a((double)((distance - startFade) / (VillagerMarkersConfig.maxDistance / 2.0 - startFade)), (double)0.2, (double)1.0);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (VillagerMarkersConfig.showThroughWalls) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            Markers.renderMarker(resource);
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
        }
        Markers.renderMarker(resource);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static void renderMarker(VillagerResource resource) {
        GlStateManager.func_179094_E();
        double scale = VillagerMarkersConfig.scale;
        boolean showArrow = VillagerMarkersConfig.showArrow;
        int yOff = -18 - VillagerMarkersConfig.verticalOffset;
        int iy = showArrow ? yOff - 9 : yOff;
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        Markers.renderIcon(resource.getMarker().texture, -8, iy);
        Markers.renderOverlay(resource.getMarker(), -8, iy);
        if (showArrow) {
            Markers.renderArrow(0, yOff);
        }
        GlStateManager.func_179121_F();
    }

    private static void renderIcon(ResourceLocation icon, int x, int y) {
        Markers.render(icon, x, y, 16, 16, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    private static void renderOverlay(MarkerResource resource, int x, int y) {
        if (resource.overlay == MarkerResource.OverlayType.NONE) {
            return;
        }
        int dx = 8;
        int dy = 8;
        int width = 8;
        int height = 8;
        int sx = 0;
        int sy = 0;
        float imageSize = 32.0f;
        ResourceLocation location = MarkerResource.NUMBER_OVERLAY;
        if (resource.overlay == MarkerResource.OverlayType.LEVEL) {
            int processedDigits = resource.level;
            int xOffset = 8;
            while (processedDigits > 0) {
                int currentDigit = processedDigits % 10;
                dx = xOffset;
                sx = currentDigit % 4 * 8;
                sy = currentDigit / 4 * 8;
                processedDigits /= 10;
                xOffset -= 5;
            }
        } else {
            sx = resource.level % 2 * 8;
            sy = resource.level / 2 * 8;
            imageSize = 16.0f;
            location = MarkerResource.ICON_OVERLAY;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
        Markers.render(location, x + dx, y + dy, width, height, (float)sx / imageSize, (float)(sx + width) / imageSize, (float)sy / imageSize, (float)(sy + height) / imageSize);
    }

    public static void renderArrow(int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(MarkerResource.MARKER_ARROW);
        Gui.func_146110_a((int)(x - 8), (int)(y + 8), (float)0.0f, (float)0.0f, (int)16, (int)8, (float)16.0f, (float)8.0f);
        GlStateManager.func_179121_F();
    }

    public static void render(ResourceLocation icon, int x, int y, int w, int h, float u0, float u1, float v0, float v1) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a((double)u0, (double)v1).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a((double)u1, (double)v1).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a((double)u1, (double)v0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)u0, (double)v0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

