/*
 * Decompiled with CFR 0.152.
 */
package com.wcl102.villagermarkers.client;

import com.wcl102.villagermarkers.client.resource.MarkerResource;
import com.wcl102.villagermarkers.client.resource.VillagerResource;
import com.wcl102.villagermarkers.network.Network;
import com.wcl102.villagermarkers.network.packets.PacketVillagerData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientVillagerManager {
    public static final Map<String, MarkerResource> resourceCache = new HashMap<String, MarkerResource>();
    public static final Map<UUID, VillagerResource> villagers = new HashMap<UUID, VillagerResource>();

    public static VillagerResource getVillagerResource(EntityVillager villager) {
        if (!villagers.containsKey(villager.func_110124_au())) {
            Network.INSTANCE.sendToServer((IMessage)new PacketVillagerData.Message(villager.func_110124_au()));
        }
        return villagers.get(villager.func_110124_au());
    }

    public static void add(UUID uuid, VillagerResource resource) {
        villagers.put(uuid, resource);
    }

    public static void remove(Entity entity) {
        villagers.remove(entity.func_110124_au());
    }

    public static MarkerResource getMarker(String key) {
        return resourceCache.get(key);
    }

    public static void addMarker(String hash, MarkerResource resource) {
        resourceCache.putIfAbsent(hash, resource);
    }

    public static boolean hasMarker(String hash) {
        return resourceCache.containsKey(hash);
    }
}

