/*
 * Decompiled with CFR 0.152.
 */
package com.wcl102.villagermarkers;

import com.wcl102.villagermarkers.client.ClientVillagerManager;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="villagermarkers", name="villager-markers")
@Mod.EventBusSubscriber(modid="villagermarkers")
public class VillagerMarkersConfig {
    @Config.Name(value="Blacklist")
    public static String[] blacklist = new String[]{"nitwit"};
    @Config.Name(value="Show Through Walls")
    public static boolean showThroughWalls = true;
    @Config.Name(value="Show Arrow")
    public static boolean showArrow = true;
    @Config.Name(value="Max Distance")
    @Config.SlidingOption
    @Config.RangeDouble(min=16.0, max=64.0)
    public static double maxDistance = 64.0;
    @Config.Comment(value={"Overlay Types", "0 - None", "1 - Icons", "2 - Level"})
    @Config.Name(value="Overlay Type")
    @Config.SlidingOption
    @Config.RangeInt(min=0, max=2)
    public static int overlayIndex = 2;
    @Config.Comment(value={"0% - No Fading"})
    @Config.Name(value="Fade %")
    @Config.SlidingOption
    @Config.RangeDouble(min=0.0, max=100.0)
    public static double fadePercent = 25.0;
    @Config.Name(value="Scale")
    @Config.SlidingOption
    @Config.RangeDouble(min=0.1, max=2.0)
    public static double scale = 1.0;
    @Config.Name(value="Vertical Offset")
    @Config.SlidingOption
    @Config.RangeInt(min=0, max=64)
    public static int verticalOffset = 0;

    private static List<String> getBlackList() {
        return Arrays.asList(blacklist);
    }

    public static boolean isBlackListed(String career) {
        if (VillagerMarkersConfig.getBlackList().contains(career)) {
            return true;
        }
        for (int i = 0; i < VillagerMarkersConfig.getBlackList().size(); ++i) {
            if (!VillagerMarkersConfig.getBlackList().get(i).contains(career)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent event) {
        if (event.getModID().equals("villagermarkers")) {
            ClientVillagerManager.villagers.clear();
            ClientVillagerManager.resourceCache.clear();
            ConfigManager.sync((String)"villagermarkers", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

