/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render;

import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.init.TEBlocks;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.render.CubeBakeryBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BakeryMachine
extends CubeBakeryBase {
    public static final BakeryMachine INSTANCE = new BakeryMachine();

    private static TextureAtlasSprite getOverlaySprite(EnumFacing face, int level) {
        if (level == 0) {
            return null;
        }
        return TETextures.MACHINE_OVERLAY[level];
    }

    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.of((String)"Null tile. Position: %s", (Object[])new Object[]{pos}));
        }
        if (!(tile instanceof TileMachineBase)) {
            return state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.of((String)"Tile is not an instance of TileMachineBase, was %s. Pos: %s", (Object[])new Object[]{tile.getClass().getName(), pos}));
        }
        state = state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.OK);
        state = state.withProperty(TEProps.TILE_MACHINE, (Object)((TileMachineBase)tile));
        state = state.withProperty(TEProps.BAKERY_WORLD, (Object)world);
        return state;
    }

    public List<BakedQuad> bakeItemQuads(EnumFacing face, ItemStack stack) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (face != null && !stack.func_190926_b()) {
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            CCRenderState ccrs = CCRenderState.instance();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            boolean creative = BlockMachine.itemBlock.isCreative(stack);
            int level = BlockMachine.itemBlock.getLevel(stack);
            BlockMachine provider = TEBlocks.blockMachine;
            this.renderFace(ccrs, face, provider.getTexture(face, stack), -1);
            if (TEProps.renderMachineOverlay && level > 0) {
                this.renderFaceOverlay(ccrs, face, creative ? TETextures.MACHINE_OVERLAY_C : BakeryMachine.getOverlaySprite(face, level), -1);
            }
            buffer.func_178977_d();
            quads.addAll(buffer.bake());
        }
        return quads;
    }

    public List<BakedQuad> bakeLayerFace(EnumFacing face, BlockRenderLayer layer, IExtendedBlockState state) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (face != null && state != null) {
            Block block = state.func_177230_c();
            IWorldBlockTextureProvider provider = (IWorldBlockTextureProvider)block;
            TileMachineBase tile = (TileMachineBase)((Object)state.getValue(TEProps.TILE_MACHINE));
            IBlockAccess world = (IBlockAccess)state.getValue(TEProps.BAKERY_WORLD);
            boolean creative = tile.isCreative;
            int level = tile.getLevel();
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            this.renderFace(ccrs, face, provider.getTexture(face, (IBlockState)state, layer, world, tile.func_174877_v()), tile.getColorMask(layer, face));
            if (layer == BlockRenderLayer.CUTOUT && TEProps.renderMachineOverlay && level > 0) {
                this.renderFace(ccrs, face, creative ? TETextures.MACHINE_OVERLAY_C : BakeryMachine.getOverlaySprite(face, level), -1);
            }
            buffer.func_178977_d();
            quads.addAll(buffer.bake());
        }
        return quads;
    }
}

