/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.dynamo.reactant;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.dynamo.TileDynamoReactant;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.dynamo.BaseFuelWrapper;
import cofh.thermalexpansion.util.managers.dynamo.ReactantManager;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ReactantFuelWrapper
extends BaseFuelWrapper {
    protected List<ItemStack> inputs;
    protected List<FluidStack> inputFluids;

    public ReactantFuelWrapper(IGuiHelper guiHelper, ReactantManager.Reaction reaction) {
        this(guiHelper, reaction, "thermalexpansion.reactant");
    }

    public ReactantFuelWrapper(IGuiHelper guiHelper, ReactantManager.Reaction reaction, String uIdIn) {
        this.uId = uIdIn;
        ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
        recipeInputs.add(reaction.getReactant());
        ArrayList<FluidStack> recipeFluids = new ArrayList<FluidStack>();
        recipeFluids.add(new FluidStack(FluidRegistry.getFluid((String)reaction.getFluidName()), TileDynamoReactant.fluidAmount));
        this.inputs = recipeInputs;
        this.inputFluids = recipeFluids;
        this.energy = reaction.getEnergy();
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getScaleFill(5);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.durationFill = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TileDynamoReactant.basePower, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputs);
        ingredients.setInputs(FluidStack.class, this.inputFluids);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.durationFill.draw(minecraft, 22, 43);
        this.energyMeter.draw(minecraft, 71, 7);
        minecraft.field_71466_p.func_78276_b(StringHelper.formatNumber((long)this.energy) + " RF", 96, (recipeHeight - 9) / 2, 0x808080);
    }
}

