/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class ItemStackUtils {
    public static NBTTagCompound saveAllItems(NBTTagCompound tag, NonNullList<ItemStack> inventory, NonNullList<ItemStack> craftingGrid) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack itemstack = (ItemStack)inventory.get(i);
            if (i <= 8) {
                ItemStack gridStack = (ItemStack)craftingGrid.get(i);
                if (gridStack.func_190926_b()) continue;
                NBTTagCompound slotTag = new NBTTagCompound();
                slotTag.func_74774_a("Slot", (byte)i);
                gridStack.func_77955_b(slotTag);
                nbttaglist.func_74742_a((NBTBase)slotTag);
                continue;
            }
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
        return tag;
    }

    public static NBTTagCompound saveAllItemsBlackList(NBTTagCompound tag, NonNullList<ItemStack> inventory, NonNullList<ItemStack> craftingGrid) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        intList.add(50);
        intList.add(52);
        intList.add(51);
        intList.add(53);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack itemstack = (ItemStack)inventory.get(i);
            if (i <= 8) {
                ItemStack gridStack = (ItemStack)craftingGrid.get(i);
                if (gridStack.func_190926_b()) continue;
                NBTTagCompound slotTag = new NBTTagCompound();
                slotTag.func_74774_a("Slot", (byte)i);
                gridStack.func_77955_b(slotTag);
                nbttaglist.func_74742_a((NBTBase)slotTag);
                continue;
            }
            if (itemstack.func_190926_b() || intList.contains(i)) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
        return tag;
    }

    public static void loadAllItems(NBTTagCompound tag, NonNullList<ItemStack> inventory, NonNullList<ItemStack> craftingGrid) {
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound entry = nbttaglist.func_150305_b(i);
            int index = entry.func_74771_c("Slot") & 0xFF;
            if (index >= inventory.size()) continue;
            if (index <= 8) {
                craftingGrid.set(index, (Object)new ItemStack(entry));
                continue;
            }
            inventory.set(index, (Object)new ItemStack(entry));
        }
    }
}

