/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.gui;

import com.tiviacz.travelersbackpack.api.events.TankTooltipEvent;
import com.tiviacz.travelersbackpack.gui.GuiTravelersBackpack;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GuiTank {
    private int height;
    private int width;
    private int startX;
    private int startY;
    private FluidTank tank;

    public GuiTank(FluidTank tank, int x, int y, int height, int width) {
        this.startX = x;
        this.startY = y;
        this.height = height;
        this.width = width;
        this.tank = tank;
    }

    public List<String> getTankTooltip() {
        String fluidAmount;
        ArrayList<String> tankTips;
        FluidStack fluidStack = this.tank.getFluid();
        if (MinecraftForge.EVENT_BUS.post((Event)new TankTooltipEvent(fluidStack, tankTips = new ArrayList<String>()))) {
            return tankTips;
        }
        String fluidName = fluidStack != null ? fluidStack.getLocalizedName() : I18n.func_135052_a((String)"gui.none.name", (Object[])new Object[0]);
        String string = fluidAmount = fluidStack != null ? fluidStack.amount + "/" + this.tank.getCapacity() : I18n.func_135052_a((String)"gui.empty.name", (Object[])new Object[0]);
        if (fluidStack != null && fluidStack.tag != null && fluidStack.tag.func_74764_b("Potion")) {
            fluidName = I18n.func_135052_a((String)PotionUtils.func_185191_c((ItemStack)FluidUtils.getItemStackFromFluidStack(fluidStack)).func_185174_b("potion.effect."), (Object[])new Object[0]);
            this.setPotionDescription(fluidStack, tankTips);
        }
        tankTips.add(fluidName);
        tankTips.add(fluidAmount);
        return tankTips;
    }

    public void setPotionDescription(FluidStack fluidStack, List<String> lores) {
        List list = PotionUtils.func_185189_a((ItemStack)FluidUtils.getItemStackFromFluidStack(fluidStack));
        if (list.isEmpty()) {
            String s = I18n.func_135052_a((String)"effect.none", (Object[])new Object[0]).trim();
            lores.add(TextFormatting.GRAY + s);
        } else {
            for (PotionEffect potioneffect : list) {
                String s1 = I18n.func_135052_a((String)potioneffect.func_76453_d(), (Object[])new Object[0]).trim();
                Potion potion = potioneffect.func_188419_a();
                if (potioneffect.func_76458_c() > 0) {
                    s1 = s1 + " " + I18n.func_135052_a((String)("potion.potency." + potioneffect.func_76458_c()), (Object[])new Object[0]).trim();
                }
                if (potioneffect.func_76459_b() > 20) {
                    s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f) + ")";
                }
                if (potion.func_76398_f()) {
                    lores.add(TextFormatting.RED + s1);
                    continue;
                }
                lores.add(TextFormatting.BLUE + s1);
            }
        }
    }

    public void drawGuiFluidBar() {
        RenderUtils.renderGuiTank(this.tank, this.startX, this.startY, this.height, this.width);
    }

    public boolean inTank(GuiTravelersBackpack gui, int mouseX, int mouseY) {
        return this.startX <= (mouseX -= gui.getGuiLeft()) && mouseX <= this.startX + this.width && this.startY <= (mouseY -= gui.getGuiTop()) && mouseY <= this.startY + this.height;
    }
}

