/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.optifine.expr.IExpression;
import net.optifine.expr.IExpressionCached;
import net.optifine.shaders.uniform.CustomUniform;

public class CustomUniforms {
    private CustomUniform[] uniforms;
    private IExpressionCached[] expressionsCached;

    public CustomUniforms(CustomUniform[] uniforms, Map<String, IExpression> mapExpressions) {
        this.uniforms = uniforms;
        ArrayList<IExpressionCached> list = new ArrayList<IExpressionCached>();
        Set<String> keys = mapExpressions.keySet();
        for (String key : keys) {
            IExpression expr = mapExpressions.get(key);
            if (!(expr instanceof IExpressionCached)) continue;
            IExpressionCached exprCached = (IExpressionCached)((Object)expr);
            list.add(exprCached);
        }
        this.expressionsCached = list.toArray(new IExpressionCached[list.size()]);
    }

    public void setProgram(int program) {
        for (int i2 = 0; i2 < this.uniforms.length; ++i2) {
            CustomUniform uniform = this.uniforms[i2];
            uniform.setProgram(program);
        }
    }

    public void update() {
        this.resetCache();
        for (int i2 = 0; i2 < this.uniforms.length; ++i2) {
            CustomUniform uniform = this.uniforms[i2];
            uniform.update();
        }
    }

    private void resetCache() {
        for (int i2 = 0; i2 < this.expressionsCached.length; ++i2) {
            IExpressionCached exprCached = this.expressionsCached[i2];
            exprCached.reset();
        }
    }

    public void reset() {
        for (int i2 = 0; i2 < this.uniforms.length; ++i2) {
            CustomUniform cu = this.uniforms[i2];
            cu.reset();
        }
    }
}

