/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.genetics.IDatabaseTab;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IDatabaseElement;
import forestry.api.gui.IElementLayoutHelper;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.ItemElement;
import forestry.core.utils.Translator;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ButterflyProductsTab
implements IDatabaseTab<IButterfly> {
    ButterflyProductsTab() {
    }

    @Override
    public void createElements(IDatabaseElement container, IButterfly individual, ItemStack itemStack) {
        Set<ItemStack> cocoonLoot;
        Set<ItemStack> caterpillarLoot;
        IElementLayoutHelper groupHelper = container.layoutHelper((x, y) -> GuiElementFactory.INSTANCE.createHorizontal(x + 4, y, 18).setDistance(2), 90, 0);
        Set<ItemStack> butterflyLoot = individual.getGenome().getPrimary().getButterflyLoot().keySet();
        if (!butterflyLoot.isEmpty()) {
            container.label(Translator.translateToLocal("for.gui.loot.butterfly"), GuiElementAlignment.TOP_CENTER);
            butterflyLoot.forEach(stack -> groupHelper.add(new ItemElement(0, 0, (ItemStack)stack)));
            groupHelper.finish();
        }
        if (!(caterpillarLoot = individual.getGenome().getPrimary().getCaterpillarLoot().keySet()).isEmpty()) {
            container.label(Translator.translateToLocal("for.gui.loot.caterpillar"), GuiElementAlignment.TOP_CENTER);
            caterpillarLoot.forEach(stack -> groupHelper.add(new ItemElement(0, 0, (ItemStack)stack)));
            groupHelper.finish();
        }
        if (!(cocoonLoot = individual.getGenome().getCocoon().getCocoonLoot().keySet()).isEmpty()) {
            container.label(Translator.translateToLocal("for.gui.loot.cocoon"), GuiElementAlignment.TOP_CENTER);
            cocoonLoot.forEach(stack -> groupHelper.add(new ItemElement(0, 0, (ItemStack)stack)));
            groupHelper.finish();
        }
    }

    @Override
    public ItemStack getIconStack() {
        return ButterflyDefinition.Aurora.getMemberStack(EnumFlutterType.SERUM);
    }
}

