/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicHomogeneous;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicSucculent
extends FarmLogicHomogeneous {
    public FarmLogicSucculent(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    public ItemStack getIconItemStack() {
        return new ItemStack(Items.field_151100_aR, 1, 2);
    }

    @Override
    public String getUnlocalizedName() {
        return "for.farm.succulent";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 1;
    }

    @Override
    protected boolean maintainGermlings(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            BlockPos soilPos;
            IBlockState blockState;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            IBlockState state = world.func_180495_p(position);
            if (!world.func_175623_d(position) && !BlockUtil.isReplaceableBlock(state, world, position) || !this.isAcceptedSoil(blockState = world.func_180495_p(soilPos = position.func_177977_b())) || !this.canPlace(world, position) || !this.trySetCrop(world, farmHousing, position, direction)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlace(World world, BlockPos position) {
        return Blocks.field_150434_aF.func_176586_d(world, position);
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }
}

