/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.ModuleCore;
import forestry.core.ModuleFluids;
import forestry.core.blocks.BlockBogEarth;
import forestry.core.blocks.BlockRegistryCore;
import forestry.core.circuits.CircuitLayout;
import forestry.core.circuits.Circuits;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemElectronTube;
import forestry.core.items.ItemRegistryCore;
import forestry.core.items.ItemRegistryFluids;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.datastructures.DummyMap;
import forestry.core.utils.datastructures.FluidMap;
import forestry.core.utils.datastructures.ItemStackMap;
import forestry.factory.DummyManagers;
import forestry.factory.MachineUIDs;
import forestry.factory.blocks.BlockRegistryFactory;
import forestry.factory.circuits.CircuitSpeedUpgrade;
import forestry.factory.network.PacketRegistryFactory;
import forestry.factory.recipes.CarpenterRecipeManager;
import forestry.factory.recipes.CentrifugeRecipeManager;
import forestry.factory.recipes.FabricatorRecipeManager;
import forestry.factory.recipes.FabricatorSmeltingRecipeManager;
import forestry.factory.recipes.FermenterRecipeManager;
import forestry.factory.recipes.MoistenerRecipeManager;
import forestry.factory.recipes.SqueezerRecipeManager;
import forestry.factory.recipes.StillRecipeManager;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import forestry.storage.ModuleCrates;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@ForestryModule(containerID="forestry", moduleID="factory", name="Factory", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.factory.description", lootTable="factory")
public class ModuleFactory
extends BlankForestryModule {
    public static final Map<String, Boolean> MACHINE_ENABLED = Maps.newHashMap();
    @Nullable
    private static BlockRegistryFactory blocks;

    public static BlockRegistryFactory getBlocks() {
        Preconditions.checkNotNull((Object)blocks);
        return blocks;
    }

    @Override
    public void setupAPI() {
        RecipeManagers.carpenterManager = ModuleFactory.machineEnabled("carpenter") ? new CarpenterRecipeManager() : new DummyManagers.DummyCarpenterManager();
        RecipeManagers.centrifugeManager = ModuleFactory.machineEnabled("centrifuge") ? new CentrifugeRecipeManager() : new DummyManagers.DummyCentrifugeManager();
        RecipeManagers.fabricatorManager = ModuleFactory.machineEnabled("fabricator") ? new FabricatorRecipeManager() : new DummyManagers.DummyFabricatorManager();
        RecipeManagers.fabricatorSmeltingManager = ModuleFactory.machineEnabled("fabricator") ? new FabricatorSmeltingRecipeManager() : new DummyManagers.DummyFabricatorSmeltingManager();
        RecipeManagers.fermenterManager = ModuleFactory.machineEnabled("fermenter") ? new FermenterRecipeManager() : new DummyManagers.DummyFermenterManager();
        RecipeManagers.moistenerManager = ModuleFactory.machineEnabled("moistener") ? new MoistenerRecipeManager() : new DummyManagers.DummyMoistenerManager();
        RecipeManagers.squeezerManager = ModuleFactory.machineEnabled("squeezer") ? new SqueezerRecipeManager() : new DummyManagers.DummySqueezerManager();
        RecipeManagers.stillManager = ModuleFactory.machineEnabled("still") ? new StillRecipeManager() : new DummyManagers.DummyStillManager();
        ModuleFactory.setupFuelManager();
    }

    @Override
    public void disabledSetupAPI() {
        RecipeManagers.carpenterManager = new DummyManagers.DummyCarpenterManager();
        RecipeManagers.centrifugeManager = new DummyManagers.DummyCentrifugeManager();
        RecipeManagers.fabricatorManager = new DummyManagers.DummyFabricatorManager();
        RecipeManagers.fabricatorSmeltingManager = new DummyManagers.DummyFabricatorSmeltingManager();
        RecipeManagers.fermenterManager = new DummyManagers.DummyFermenterManager();
        RecipeManagers.moistenerManager = new DummyManagers.DummyMoistenerManager();
        RecipeManagers.squeezerManager = new DummyManagers.DummySqueezerManager();
        RecipeManagers.stillManager = new DummyManagers.DummyStillManager();
        ModuleFactory.setupFuelManager();
    }

    private static void setupFuelManager() {
        FuelManager.fermenterFuel = ModuleFactory.machineEnabled("fermenter") ? new ItemStackMap() : new DummyMap();
        FuelManager.moistenerResource = ModuleFactory.machineEnabled("moistener") ? new ItemStackMap() : new DummyMap();
        FuelManager.rainSubstrate = ModuleFactory.machineEnabled("rainmaker") ? new ItemStackMap() : new DummyMap();
        FuelManager.bronzeEngineFuel = new FluidMap<EngineBronzeFuel>();
        FuelManager.copperEngineFuel = new ItemStackMap<EngineCopperFuel>();
        FuelManager.generatorFuel = new FluidMap<GeneratorFuel>();
    }

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryFactory();
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryFactory();
    }

    @Override
    public void preInit() {
        Fluid juice;
        Fluid honey;
        Fluid seedOil;
        ItemRegistryCore coreItems = ModuleCore.getItems();
        ItemStack fertilizerCompound = coreItems.fertilizerCompound.getItemStack();
        FuelManager.fermenterFuel.put(fertilizerCompound, new FermenterFuel(fertilizerCompound, ForestryAPI.activeMode.getIntegerSetting("fermenter.value.fertilizer"), ForestryAPI.activeMode.getIntegerSetting("fermenter.cycles.fertilizer")));
        ItemStack fertilizerBio = coreItems.compost.getItemStack();
        FuelManager.fermenterFuel.put(fertilizerBio, new FermenterFuel(fertilizerBio, ForestryAPI.activeMode.getIntegerSetting("fermenter.cycles.compost"), ForestryAPI.activeMode.getIntegerSetting("fermenter.value.compost")));
        ItemStack mulch = coreItems.mulch.getItemStack();
        FuelManager.fermenterFuel.put(mulch, new FermenterFuel(mulch, ForestryAPI.activeMode.getIntegerSetting("fermenter.cycles.mulch"), ForestryAPI.activeMode.getIntegerSetting("fermenter.value.mulch")));
        ItemStack wheat = new ItemStack(Items.field_151015_O);
        ItemStack mouldyWheat = coreItems.mouldyWheat.getItemStack();
        ItemStack decayingWheat = coreItems.decayingWheat.getItemStack();
        FuelManager.moistenerResource.put(wheat, new MoistenerFuel(wheat, mouldyWheat, 0, 300));
        FuelManager.moistenerResource.put(mouldyWheat, new MoistenerFuel(mouldyWheat, decayingWheat, 1, 600));
        FuelManager.moistenerResource.put(decayingWheat, new MoistenerFuel(decayingWheat, mulch, 2, 900));
        ItemStack peat = coreItems.peat.getItemStack();
        FuelManager.copperEngineFuel.put(peat, new EngineCopperFuel(peat, 20, 2500));
        ItemStack bituminousPeat = coreItems.bituminousPeat.getItemStack();
        FuelManager.copperEngineFuel.put(bituminousPeat, new EngineCopperFuel(bituminousPeat, 40, 3000));
        Fluid biomass = Fluids.BIOMASS.getFluid();
        if (biomass != null) {
            FuelManager.bronzeEngineFuel.put(biomass, new EngineBronzeFuel(biomass, 50, (int)(2500.0f * ForestryAPI.activeMode.getFloatSetting("fuel.biomass.biogas")), 1));
        }
        FuelManager.bronzeEngineFuel.put(FluidRegistry.WATER, new EngineBronzeFuel(FluidRegistry.WATER, 10, 1000, 3));
        Fluid milk = Fluids.MILK.getFluid();
        if (milk != null) {
            FuelManager.bronzeEngineFuel.put(milk, new EngineBronzeFuel(milk, 10, 10000, 3));
        }
        if ((seedOil = Fluids.SEED_OIL.getFluid()) != null) {
            FuelManager.bronzeEngineFuel.put(seedOil, new EngineBronzeFuel(seedOil, 30, 2500, 1));
        }
        if ((honey = Fluids.FOR_HONEY.getFluid()) != null) {
            FuelManager.bronzeEngineFuel.put(honey, new EngineBronzeFuel(honey, 20, 2500, 1));
        }
        if ((juice = Fluids.JUICE.getFluid()) != null) {
            FuelManager.bronzeEngineFuel.put(juice, new EngineBronzeFuel(juice, 10, 2500, 1));
        }
        ItemStack iodineCharge = coreItems.iodineCharge.getItemStack();
        ItemStack dissipationCharge = coreItems.craftingMaterial.getDissipationCharge();
        FuelManager.rainSubstrate.put(iodineCharge, new RainSubstrate(iodineCharge, 10000, 0.01f));
        FuelManager.rainSubstrate.put(dissipationCharge, new RainSubstrate(dissipationCharge, 0.075f));
        CircuitLayout layoutMachineUpgrade = new CircuitLayout("machine.upgrade", CircuitSocketType.MACHINE);
        ChipsetManager.circuitRegistry.registerLayout(layoutMachineUpgrade);
    }

    @Override
    public void addLootPoolNames(Set<String> lootPoolNames) {
        lootPoolNames.add("forestry_factory_items");
    }

    @Override
    public void registerTriggers() {
    }

    @Override
    public void doInit() {
        BlockRegistryFactory blocks = ModuleFactory.getBlocks();
        blocks.bottler.init();
        blocks.carpenter.init();
        blocks.centrifuge.init();
        blocks.fermenter.init();
        blocks.moistener.init();
        blocks.squeezer.init();
        blocks.still.init();
        blocks.rainmaker.init();
        blocks.fabricator.init();
        blocks.raintank.init();
        Circuits.machineSpeedUpgrade1 = new CircuitSpeedUpgrade("machine.speed.boost.1", 0.125, 0.05f);
        Circuits.machineSpeedUpgrade2 = new CircuitSpeedUpgrade("machine.speed.boost.2", 0.25, 0.1f);
        Circuits.machineEfficiencyUpgrade1 = new CircuitSpeedUpgrade("machine.efficiency.1", 0.0, -0.1f);
    }

    @Override
    public void registerRecipes() {
        ICircuitLayout layout;
        int seedOilAmount;
        FluidStack seedOil;
        ItemRegistryCore coreItems = ModuleCore.getItems();
        BlockRegistryCore coreBlocks = ModuleCore.getBlocks();
        ItemRegistryFluids fluidItems = ModuleFluids.getItems();
        BlockRegistryFactory blocks = ModuleFactory.getBlocks();
        ItemElectronTube electronTube = coreItems.tubes;
        FluidStack liquidGlass = Fluids.GLASS.getFluid(500);
        if (liquidGlass != null) {
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.COPPER, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotCopper"});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.TIN, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotTin"});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.BRONZE, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotBronze"});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.IRON, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotIron"});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.GOLD, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotGold"});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.DIAMOND, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemDiamond"});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.OBSIDIAN, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), Blocks.field_150343_Z});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.BLAZE, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), Items.field_151065_br});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.EMERALD, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemEmerald"});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.APATITE, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemApatite"});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.LAPIS, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 4)});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.ENDER, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), new ItemStack(Items.field_151061_bv, 1, 0), Character.valueOf('X'), new ItemStack(Blocks.field_150377_bs, 1, 0)});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, electronTube.get(EnumElectronTube.ORCHID, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), new ItemStack(Items.field_151107_aW, 1, 0), Character.valueOf('X'), new ItemStack(Blocks.field_150450_ax, 1, 0)});
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, liquidGlass, coreItems.flexibleCasing.getItemStack(), new Object[]{"#E#", "B B", "#E#", Character.valueOf('#'), "ingotBronze", Character.valueOf('B'), "slimeball", Character.valueOf('E'), "gemEmerald"});
        }
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        FluidStack liquidGlassBucket = Fluids.GLASS.getFluid(1000);
        FluidStack liquidGlassX4 = Fluids.GLASS.getFluid(4000);
        if (ModuleHelper.isEnabled("apiculture")) {
            ItemRegistryApiculture beeItems = ModuleApiculture.getItems();
            if (liquidGlassBucket != null && liquidGlassX4 != null) {
                for (int i = 0; i < 16; ++i) {
                    RecipeManagers.fabricatorManager.addRecipe(beeItems.waxCast.getWildcard(), liquidGlassBucket, new ItemStack((Block)Blocks.field_150399_cn, 4, 15 - i), new Object[]{"#", "X", Character.valueOf('#'), dyes[i], Character.valueOf('X'), beeItems.propolis.getWildcard()});
                }
                RecipeManagers.fabricatorManager.addRecipe(beeItems.waxCast.getWildcard(), liquidGlassX4, new ItemStack(Blocks.field_150359_w, 1, 0), new Object[]{"X", Character.valueOf('X'), beeItems.propolis.getWildcard()});
            }
        }
        int appleMulchAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.mulch.apple");
        int appleJuiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
        FluidStack appleJuice = Fluids.JUICE.getFluid(appleJuiceAmount);
        if (appleJuice != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(Items.field_151034_e), appleJuice, coreItems.mulch.getItemStack(), appleMulchAmount);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(Items.field_151172_bF), appleJuice, coreItems.mulch.getItemStack(), appleMulchAmount);
        }
        if ((seedOil = Fluids.SEED_OIL.getFluid(seedOilAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed"))) != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(Items.field_151014_N), seedOil);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(Items.field_151080_bb), seedOil);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(Items.field_151081_bc), seedOil);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(Items.field_185163_cU), seedOil);
        }
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Block)Blocks.field_150434_aF), new FluidStack(FluidRegistry.WATER, 500));
        NonNullList lavaRecipeResources = NonNullList.func_191196_a();
        lavaRecipeResources.add((Object)coreItems.phosphor.getItemStack(2));
        lavaRecipeResources.add((Object)new ItemStack(Blocks.field_150347_e));
        RecipeManagers.squeezerManager.addRecipe(10, (NonNullList<ItemStack>)lavaRecipeResources, new FluidStack(FluidRegistry.LAVA, 1600));
        NonNullList iceRecipeResources = NonNullList.func_191196_a();
        iceRecipeResources.add((Object)new ItemStack(Items.field_151126_ay));
        iceRecipeResources.add((Object)coreItems.craftingMaterial.getIceShard(4));
        FluidStack liquidIce = Fluids.ICE.getFluid(4000);
        if (liquidIce != null) {
            RecipeManagers.squeezerManager.addRecipe(10, (NonNullList<ItemStack>)iceRecipeResources, liquidIce);
        }
        FluidStack biomass = Fluids.BIOMASS.getFluid(10);
        FluidStack ethanol = Fluids.BIO_ETHANOL.getFluid(3);
        if (biomass != null && ethanol != null) {
            RecipeManagers.stillManager.addRecipe(100, biomass, ethanol);
        }
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Items.field_151014_N), new ItemStack((Block)Blocks.field_150391_bh), 5000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150341_Y), 20000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150417_aV, 1, 1), 20000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack((Block)Blocks.field_150362_t, 1, BlockPlanks.EnumType.SPRUCE.ordinal()), new ItemStack(Blocks.field_150346_d, 1, BlockDirt.DirtType.PODZOL.ordinal()), 5000);
        RecipeUtil.addFermenterRecipes("treeSapling", ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes("blockCactus", ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.cactus"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes("cropWheat", ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes("cropPotato", 2 * ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes("sugarcane", ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.cane"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack((Block)Blocks.field_150338_P), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.mushroom"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack((Block)Blocks.field_150337_Q), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.mushroom"), Fluids.BIOMASS);
        FluidStack liquidGlass375 = Fluids.GLASS.getFluid(375);
        if (liquidGlass375 != null && liquidGlassBucket != null && liquidGlassX4 != null) {
            RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150359_w), liquidGlassBucket, 1000);
            RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150410_aZ), liquidGlass375, 1000);
            RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack((Block)Blocks.field_150354_m), liquidGlassBucket, 3000);
            RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack((Block)Blocks.field_150354_m, 1, 1), liquidGlassBucket, 3000);
            RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150322_A), liquidGlassX4, 4800);
            RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150322_A, 1, 1), liquidGlassX4, 4800);
            RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150322_A, 1, 2), liquidGlassX4, 4800);
        }
        RecipeManagers.carpenterManager.addRecipe(50, Fluids.SEED_OIL.getFluid(250), ItemStack.field_190927_a, coreItems.impregnatedCasing.getItemStack(), "###", "# #", "###", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(50, Fluids.SEED_OIL.getFluid(500), ItemStack.field_190927_a, new ItemStack((Block)coreBlocks.escritoire), "#  ", "###", "# #", Character.valueOf('#'), "plankWood");
        RecipeManagers.carpenterManager.addRecipe(10, Fluids.SEED_OIL.getFluid(100), ItemStack.field_190927_a, coreItems.stickImpregnated.getItemStack(2), "#", "#", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 250), ItemStack.field_190927_a, coreItems.woodPulp.getItemStack(4), "#", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 250), ItemStack.field_190927_a, new ItemStack(Items.field_151121_aF, 1), "#", "#", Character.valueOf('#'), "pulpWood");
        RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, new ItemStack((Block)coreBlocks.humus, 9), "###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), coreItems.mulch);
        RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, coreBlocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, 8), "#X#", "XYX", "#X#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), "sand", Character.valueOf('Y'), coreItems.mulch);
        RecipeManagers.carpenterManager.addRecipe(75, new FluidStack(FluidRegistry.WATER, 5000), ItemStack.field_190927_a, coreItems.hardenedCasing.getItemStack(), "# #", " Y ", "# #", Character.valueOf('#'), "gemDiamond", Character.valueOf('Y'), coreItems.sturdyCasing);
        ItemStack basicCircuitboard = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.BASIC, null, new ICircuit[0]);
        ItemStack enhancedCircuitboard = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.ENHANCED, null, new ICircuit[0]);
        ItemStack refinedCircuitboard = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]);
        ItemStack intricateCircuitboard = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.INTRICATE, null, new ICircuit[0]);
        RecipeManagers.carpenterManager.addRecipe(20, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, basicCircuitboard, "R R", "R#R", "R R", Character.valueOf('#'), "ingotTin", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(40, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, enhancedCircuitboard, "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotBronze", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(80, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, refinedCircuitboard, "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotIron", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(80, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, intricateCircuitboard, "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotGold", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(40, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, coreItems.solderingIron.getItemStack(), " # ", "# #", "  B", Character.valueOf('#'), "ingotIron", Character.valueOf('B'), "ingotBronze");
        if (ModuleHelper.isEnabled("apiculture")) {
            ItemRegistryApiculture beeItems = ModuleApiculture.getItems();
            RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, coreItems.iodineCharge.getItemStack(), "Z#Z", "#Y#", "X#X", Character.valueOf('#'), beeItems.pollenCluster.getWildcard(), Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), fluidItems.canEmpty, Character.valueOf('Z'), beeItems.honeyDrop);
            RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, coreItems.craftingMaterial.getDissipationCharge(), "Z#Z", "#Y#", "X#X", Character.valueOf('#'), beeItems.royalJelly, Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), fluidItems.canEmpty, Character.valueOf('Z'), beeItems.honeydew);
        }
        RecipeManagers.carpenterManager.addRecipe(100, ItemStack.field_190927_a, new ItemStack(Items.field_151079_bi, 1), " # ", "###", " # ", Character.valueOf('#'), coreItems.craftingMaterial.getPulsatingMesh());
        RecipeManagers.carpenterManager.addRecipe(10, new FluidStack(FluidRegistry.WATER, 500), ItemStack.field_190927_a, coreItems.craftingMaterial.getWovenSilk(), "###", "###", "###", Character.valueOf('#'), coreItems.craftingMaterial.getSilkWisp());
        RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, coreItems.carton.getItemStack(2), " # ", "# #", " # ", Character.valueOf('#'), "pulpWood");
        RecipeManagers.carpenterManager.addRecipe(20, (FluidStack)null, coreItems.carton.getItemStack(), coreItems.kitPickaxe.getItemStack(), "###", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeManagers.carpenterManager.addRecipe(20, (FluidStack)null, coreItems.carton.getItemStack(), coreItems.kitShovel.getItemStack(), " # ", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        ItemStack ingotBronze = coreItems.ingotBronze.func_77946_l();
        ingotBronze.func_190920_e(2);
        RecipeManagers.carpenterManager.addRecipe(ItemStack.field_190927_a, ingotBronze, "#", Character.valueOf('#'), coreItems.brokenBronzePickaxe);
        ingotBronze = ingotBronze.func_77946_l();
        ingotBronze.func_190920_e(1);
        RecipeManagers.carpenterManager.addRecipe(ItemStack.field_190927_a, ingotBronze, "#", Character.valueOf('#'), coreItems.brokenBronzeShovel);
        if (ModuleHelper.isEnabled("crates")) {
            ModuleCrates.createCrateRecipes();
        }
        if ((layout = ChipsetManager.circuitRegistry.getLayout("forestry.machine.upgrade")) != null) {
            ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.EMERALD, 1), Circuits.machineSpeedUpgrade1);
            ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.BLAZE, 1), Circuits.machineSpeedUpgrade2);
            ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.GOLD, 1), Circuits.machineEfficiencyUpgrade1);
        }
        if (ModuleFactory.machineEnabled("bottler")) {
            RecipeUtil.addRecipe("bottler", blocks.bottler, "X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), fluidItems.canEmpty, Character.valueOf('Y'), coreItems.sturdyCasing);
        }
        if (ModuleFactory.machineEnabled("carpenter")) {
            RecipeUtil.addRecipe("carpenter", blocks.carpenter, "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), coreItems.sturdyCasing);
        }
        if (ModuleFactory.machineEnabled("centrifuge")) {
            RecipeUtil.addRecipe("centrifuge", blocks.centrifuge, "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), coreItems.sturdyCasing);
        }
        if (ModuleFactory.machineEnabled("fermenter")) {
            RecipeUtil.addRecipe("fermenter", blocks.fermenter, "X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearBronze", Character.valueOf('Y'), coreItems.sturdyCasing);
        }
        if (ModuleFactory.machineEnabled("moistener")) {
            RecipeUtil.addRecipe("moistener", blocks.moistener, "X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearCopper", Character.valueOf('Y'), coreItems.sturdyCasing);
        }
        if (ModuleFactory.machineEnabled("squeezer")) {
            RecipeUtil.addRecipe("squeezer", blocks.squeezer, "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotTin", Character.valueOf('Y'), coreItems.sturdyCasing);
        }
        if (ModuleFactory.machineEnabled("still")) {
            RecipeUtil.addRecipe("still", blocks.still, "X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "dustRedstone", Character.valueOf('Y'), coreItems.sturdyCasing);
        }
        if (ModuleFactory.machineEnabled("rainmaker")) {
            RecipeUtil.addRecipe("rainmaker", blocks.rainmaker, "X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearTin", Character.valueOf('Y'), coreItems.hardenedCasing);
        }
        if (ModuleFactory.machineEnabled("fabricator")) {
            RecipeUtil.addRecipe("fabricator", blocks.fabricator, "X#X", "#Y#", "XZX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotGold", Character.valueOf('Y'), coreItems.sturdyCasing, Character.valueOf('Z'), "chestWood");
        }
        if (ModuleFactory.machineEnabled("raintank")) {
            RecipeUtil.addRecipe("raintank", blocks.raintank, "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotIron", Character.valueOf('Y'), coreItems.sturdyCasing);
        }
    }

    public static void loadMachineConfig(LocalizedConfiguration config) {
        List<String> enabled = Arrays.asList(config.getStringListLocalized("machines", "enabled", MachineUIDs.ALL.toArray(new String[0]), MachineUIDs.ALL.toArray(new String[0])));
        for (String machineID : MachineUIDs.ALL) {
            MACHINE_ENABLED.put(machineID, enabled.contains(machineID));
        }
    }

    public static boolean machineEnabled(String machineName) {
        Boolean ret = MACHINE_ENABLED.get(machineName);
        return ret != null && ret != false;
    }
}

