/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.ForestryAPI;
import forestry.core.utils.Log;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public abstract class EntityUtil {
    @Nullable
    public static <E extends EntityLiving> E spawnEntity(World world, Class<E> entityClass, double x, double y, double z) {
        E entityLiving = EntityUtil.createEntity(world, entityClass);
        if (entityLiving == null) {
            return null;
        }
        return EntityUtil.spawnEntity(world, entityLiving, x, y, z);
    }

    public static <E extends EntityLiving> E spawnEntity(World world, E living, double x, double y, double z) {
        living.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        living.field_70759_as = living.field_70177_z;
        living.field_70761_aq = living.field_70177_z;
        living.func_180482_a(world.func_175649_E(new BlockPos(x, y, z)), null);
        world.func_72838_d(living);
        living.func_70642_aH();
        return living;
    }

    public static void registerEntity(ResourceLocation registryName, Class<? extends Entity> entityClass, String ident, int id, int eggForeground, int eggBackground, int trackingRange, int updateFrequency, boolean sendVelocity) {
        EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)ident, (int)id, (Object)ForestryAPI.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocity);
        Log.debug("Registered entity {} ({}) with id {}.", ident, entityClass.toString(), id);
    }

    @Nullable
    private static <E extends EntityLiving> E createEntity(World world, Class<E> entityClass) {
        ResourceLocation name = EntityList.func_191306_a(entityClass);
        if (name == null) {
            return null;
        }
        Entity entity = EntityList.func_188429_b((ResourceLocation)name, (World)world);
        return (E)((EntityLiving)entityClass.cast(entity));
    }
}

