/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketGenomeTrackerSync
extends ForestryPacket
implements IForestryPacketClient {
    private final NBTTagCompound nbt;

    public PacketGenomeTrackerSync(NBTTagCompound nbtTagCompound) {
        this.nbt = nbtTagCompound;
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.GENOME_TRACKER_UPDATE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_150786_a(this.nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            String type;
            ISpeciesRoot root;
            NBTTagCompound nbt = data.func_150793_b();
            if (nbt != null && (root = AlleleManager.alleleRegistry.getSpeciesRoot(type = nbt.func_74779_i("TYPE"))) != null) {
                IBreedingTracker tracker = root.getBreedingTracker(player.func_130014_f_(), player.func_146103_bH());
                tracker.decodeFromNBT(nbt);
                MinecraftForge.EVENT_BUS.post((Event)new ForestryEvent.SyncedBreedingTracker(tracker, player));
            }
        }
    }
}

