/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.climate.ClimateCapabilities;
import forestry.api.climate.IClimateListener;
import forestry.api.climate.IClimateState;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketClimateListenerUpdateEntity
extends ForestryPacket
implements IForestryPacketClient {
    private final Entity entity;
    private final IClimateState state;

    public PacketClimateListenerUpdateEntity(Entity entity, IClimateState state) {
        this.entity = entity;
        this.state = state;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.writeEntityById(this.entity);
        data.writeClimateState(this.state);
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.CLIMATE_LISTENER_UPDATE;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            IClimateListener listener;
            Entity entity = data.readEntityById(player.field_70170_p);
            IClimateState state = data.readClimateState();
            if (entity != null && entity.hasCapability(ClimateCapabilities.CLIMATE_LISTENER, null) && (listener = (IClimateListener)entity.getCapability(ClimateCapabilities.CLIMATE_LISTENER, null)) != null) {
                listener.setClimateState(state);
            }
        }
    }
}

