/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import forestry.core.gui.slots.SlotWatched;
import forestry.core.render.TextureManagerForestry;
import forestry.core.tiles.IFilterSlotDelegate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotFiltered
extends SlotWatched {
    private final IFilterSlotDelegate filterSlotDelegate;
    @Nullable
    private String backgroundTexture = null;
    private String blockedTexture = "slots/blocked";

    public <T extends IInventory & IFilterSlotDelegate> SlotFiltered(T inventory, int slotIndex, int xPos, int yPos) {
        super(inventory, slotIndex, xPos, yPos);
        this.filterSlotDelegate = inventory;
    }

    public boolean func_75214_a(ItemStack itemstack) {
        int slotIndex = this.getSlotIndex();
        return !this.filterSlotDelegate.isLocked(slotIndex) && (itemstack.func_190926_b() || this.filterSlotDelegate.canSlotAccept(slotIndex, itemstack));
    }

    public SlotFiltered setBlockedTexture(String ident) {
        this.blockedTexture = ident;
        return this;
    }

    public SlotFiltered setBackgroundTexture(String backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public TextureAtlasSprite getBackgroundSprite() {
        ItemStack stack = this.func_75211_c();
        if (!this.func_75214_a(stack)) {
            return TextureManagerForestry.getInstance().getDefault(this.blockedTexture);
        }
        if (this.backgroundTexture != null) {
            return TextureManagerForestry.getInstance().getDefault(this.backgroundTexture);
        }
        return null;
    }
}

