/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.IMultiblockLogic;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MultiblockTileEntityBase<T extends IMultiblockLogic>
extends TileEntity
implements IMultiblockComponent {
    private final T multiblockLogic;

    public MultiblockTileEntityBase(T multiblockLogic) {
        this.multiblockLogic = multiblockLogic;
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    public T getMultiblockLogic() {
        return this.multiblockLogic;
    }

    @Override
    public abstract void onMachineAssembled(IMultiblockController var1, BlockPos var2, BlockPos var3);

    @Override
    public abstract void onMachineBroken();

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.multiblockLogic.readFromNBT(data);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        this.multiblockLogic.writeToNBT(data);
        return data;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.multiblockLogic.invalidate(this.field_145850_b, this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.multiblockLogic.onChunkUnload(this.field_145850_b, this);
    }

    public final void func_145829_t() {
        super.func_145829_t();
        this.multiblockLogic.validate(this.field_145850_b, this);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        this.multiblockLogic.encodeDescriptionPacket(updateTag);
        this.encodeDescriptionPacket(updateTag);
        return updateTag;
    }

    @SideOnly(value=Side.CLIENT)
    public final void onDataPacket(NetworkManager network, SPacketUpdateTileEntity packet) {
        super.onDataPacket(network, packet);
        NBTTagCompound nbtData = packet.func_148857_g();
        this.multiblockLogic.decodeDescriptionPacket(nbtData);
        this.decodeDescriptionPacket(nbtData);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.multiblockLogic.decodeDescriptionPacket(tag);
        this.decodeDescriptionPacket(tag);
    }

    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
    }

    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
    }
}

