/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiProperties;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;

public class GuiProperties
implements IGuiProperties {
    private final Class<? extends GuiScreen> guiClass;
    private final int guiLeft;
    private final int guiTop;
    private final int guiXSize;
    private final int guiYSize;
    private final int screenWidth;
    private final int screenHeight;

    @Nullable
    public static GuiProperties create(GuiContainer guiContainer) {
        if (guiContainer.field_146294_l == 0 || guiContainer.field_146295_m == 0) {
            return null;
        }
        return new GuiProperties(guiContainer.getClass(), guiContainer.getGuiLeft(), guiContainer.getGuiTop(), guiContainer.getXSize(), guiContainer.getYSize(), guiContainer.field_146294_l, guiContainer.field_146295_m);
    }

    public static GuiProperties create(RecipesGui recipesGui) {
        int extraWidth = recipesGui.getRecipeCatalystExtraWidth();
        return new GuiProperties(recipesGui.getClass(), recipesGui.getGuiLeft() - extraWidth, recipesGui.getGuiTop(), recipesGui.getXSize() + extraWidth, recipesGui.getYSize(), recipesGui.field_146294_l, recipesGui.field_146295_m);
    }

    public static boolean areEqual(@Nullable IGuiProperties a, @Nullable IGuiProperties b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.getGuiClass().equals(b.getGuiClass()) && a.getGuiLeft() == b.getGuiLeft() && a.getGuiXSize() == b.getGuiXSize() && a.getScreenWidth() == b.getScreenWidth() && a.getScreenHeight() == b.getScreenHeight();
    }

    private GuiProperties(Class<? extends GuiScreen> guiClass, int guiLeft, int guiTop, int guiXSize, int guiYSize, int screenWidth, int screenHeight) {
        this.guiClass = guiClass;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.guiXSize = guiXSize;
        this.guiYSize = guiYSize;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass() {
        return this.guiClass;
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getGuiXSize() {
        return this.guiXSize;
    }

    @Override
    public int getGuiYSize() {
        return this.guiYSize;
    }

    @Override
    public int getScreenWidth() {
        return this.screenWidth;
    }

    @Override
    public int getScreenHeight() {
        return this.screenHeight;
    }
}

