/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.MyConfig;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class WallBiomeDataManager {
    private static Hashtable<String, WallBiomeDataItem> wallBiomeDataHashtable = new Hashtable();

    public static WallBiomeDataItem getWallBiomeDataItem(String key) {
        String iKey = key;
        if (wallBiomeDataHashtable.isEmpty()) {
            WallBiomeDataManager.wallBiomeDataInit();
        }
        WallBiomeDataItem r = wallBiomeDataHashtable.get(iKey);
        if (MyConfig.aDebugLevel > 1) {
            System.out.println("222 WallBiomeDataItem: " + iKey + " wall=" + r.getWallBlockState().func_177230_c().toString() + ".");
        }
        if (r == null) {
            if (MyConfig.aDebugLevel > 0) {
                System.out.println("Error!  Unknown Biome in Wall Biome Data:" + key + ".");
            }
            r = wallBiomeDataHashtable.get("minecraft:plains");
        }
        return r;
    }

    public static String getWallBiomeDataHashAsString() {
        String returnString = "";
        for (String key : wallBiomeDataHashtable.keySet()) {
            int wallSize = WallBiomeDataManager.wallBiomeDataHashtable.get((Object)key).wallSize;
            IBlockState wallTypeBlockState = wallBiomeDataHashtable.get(key).getWallBlockState();
            String tempString = key + "," + wallSize + "," + wallTypeBlockState.toString() + ";";
            returnString = returnString + tempString;
        }
        return returnString;
    }

    public static void wallBiomeDataInit() {
        wallBiomeDataHashtable.clear();
        for (int i = 0; i < MyConfig.defaultWallBiomeData.length; ++i) {
            try {
                String modAndBiome;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultWallBiomeData[i], ",");
                String key = modAndBiome = st.nextToken();
                String wallSizeString = st.nextToken();
                int wallSize = Integer.parseInt(wallSizeString.trim());
                if (wallSize <= 32) {
                    wallSize = 32;
                }
                if (wallSize > 80) {
                    wallSize = 80;
                }
                String wallBlockKey = st.nextToken();
                IBlockState wallBlockState = null;
                if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(wallBlockKey))) {
                    System.out.println("Regrowth Debug: Wall Foundation Block: " + wallBlockKey + " not in Forge Entity Type Registry.  Mispelled?  Missing semicolon? ");
                    wallBlockState = Blocks.field_150463_bK.func_176223_P();
                } else {
                    wallBlockState = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(wallBlockKey))).func_176223_P();
                }
                wallBiomeDataHashtable.put(key, new WallBiomeDataItem(wallSize, wallBlockState));
                continue;
            }
            catch (Exception e) {
                System.out.println("Regrowth Debug:  Bad Wall Biome Data Config : " + MyConfig.defaultWallBiomeData[i]);
            }
        }
    }

    public static class WallBiomeDataItem {
        int wallSize;
        IBlockState wallBlockState;
        IBlockState fenceBlockState;

        public WallBiomeDataItem(int wallSize, IBlockState wallBlockState) {
            this.wallSize = wallSize;
            this.wallBlockState = wallBlockState;
            this.fenceBlockState = this.fenceBlockState;
        }

        public int getWallDiameter() {
            return this.wallSize;
        }

        public IBlockState getWallBlockState() {
            return this.wallBlockState;
        }
    }
}

