/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.MyConfig;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class RegrowthEntitiesManager {
    public static Hashtable<String, RegrowthMobItem> regrowthMobHashtable = new Hashtable();

    public static RegrowthMobItem getRegrowthMobInfo(String key) {
        String iKey = key;
        if (regrowthMobHashtable.isEmpty()) {
            RegrowthEntitiesManager.regrowthMobInit();
        }
        RegrowthMobItem r = regrowthMobHashtable.get(iKey);
        return r;
    }

    public static String getRegrowthHashAsString() {
        String returnString = "";
        for (String key : regrowthMobHashtable.keySet()) {
            String regrowthType = RegrowthEntitiesManager.regrowthMobHashtable.get((Object)key).regrowthAction;
            double percentage = RegrowthEntitiesManager.regrowthMobHashtable.get((Object)key).regrowthEventSeconds;
            String tempString = key + "," + regrowthType + "," + percentage + ";";
            returnString = returnString + tempString;
        }
        return returnString;
    }

    public static void regrowthMobInit() {
        regrowthMobHashtable.clear();
        for (int i = 0; i < MyConfig.defaultRegrowthMobs.length; ++i) {
            try {
                String modAndEntity;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultRegrowthMobs[i], ",");
                String key = modAndEntity = st.nextToken();
                String regrowthType = st.nextToken();
                String secondsString = st.nextToken();
                double seconds = Double.parseDouble(secondsString.trim());
                if (seconds <= 1.0) {
                    seconds = 1.0;
                }
                regrowthMobHashtable.put(key, new RegrowthMobItem(regrowthType, seconds));
                if (ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(modAndEntity))) continue;
                System.out.println("Regrowth Debug: Mob: " + modAndEntity + " not in Forge Entity Type Registry.  Mispelled?");
                continue;
            }
            catch (Exception e) {
                System.out.println("Regrowth Debug:  Bad Mob Config : " + MyConfig.defaultRegrowthMobs[i]);
            }
        }
    }

    public static class RegrowthMobItem {
        double regrowthEventSeconds;
        String regrowthAction;

        public RegrowthMobItem(String regrowthType, double regrowthEventSeconds) {
            this.regrowthAction = regrowthType;
            this.regrowthEventSeconds = regrowthEventSeconds;
        }

        public String getRegrowthActions() {
            return this.regrowthAction.toLowerCase();
        }

        public double getRegrowthEventSeconds() {
            return this.regrowthEventSeconds;
        }
    }
}

