/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.gen;

import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.world.gen.RatStructure;
import com.github.alexthe666.rats.server.world.gen.RatsStructureProcessor;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class WorldGenRatRuin
extends WorldGenerator {
    public EnumFacing facing;

    public WorldGenRatRuin(EnumFacing facing) {
        super(false);
        this.facing = facing;
    }

    public static boolean isPartOfRuin(IBlockState state) {
        return state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_RAW || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_PILLAR || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_CHISELED || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_STAIRS || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_SLAB || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_DOUBLESLAB || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_BRICK || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_BRICK_CHISELED || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_STAIRS || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_BRICK_SLAB || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_DOUBLESLAB || state.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_TILE;
    }

    public static Rotation getRotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static BlockPos getGround(BlockPos pos, World world) {
        return WorldGenRatRuin.getGround(pos.func_177958_n(), pos.func_177952_p(), world);
    }

    public static BlockPos getGround(int x, int z, World world) {
        BlockPos skyPos = new BlockPos(x, world.func_72800_K(), z);
        while ((!world.func_180495_p(skyPos).func_185914_p() || WorldGenRatRuin.canHeightSkipBlock(skyPos, world)) && skyPos.func_177956_o() > 1) {
            skyPos = skyPos.func_177977_b();
        }
        return skyPos;
    }

    private static boolean canHeightSkipBlock(BlockPos pos, World world) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockLog || state.func_177230_c() instanceof BlockLeaves || state.func_177230_c() instanceof BlockLiquid;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        RatStructure model = RatStructure.HUT;
        int chance = rand.nextInt(99) + 1;
        BlockPos offsetPos = BlockPos.field_177992_a;
        if (chance < 10) {
            model = rand.nextBoolean() ? RatStructure.CHEESE_STATUETTE : RatStructure.GIANT_CHEESE;
        } else if (chance < 50) {
            switch (rand.nextInt(5)) {
                case 1: {
                    model = RatStructure.PILLAR;
                    break;
                }
                case 2: {
                    model = RatStructure.PILLAR_LEANING;
                    offsetPos = new BlockPos(0, -2, 0);
                    break;
                }
                case 3: {
                    model = RatStructure.PILLAR_COLLECTION;
                    break;
                }
                case 4: {
                    model = RatStructure.PILLAR_THIN;
                    break;
                }
                default: {
                    model = RatStructure.PILLAR_LEANING;
                    offsetPos = new BlockPos(0, -2, 0);
                    break;
                }
            }
        } else if (chance < 70) {
            switch (rand.nextInt(5)) {
                case 1: {
                    model = RatStructure.TOWER;
                    break;
                }
                case 2: {
                    model = RatStructure.FORUM;
                    break;
                }
                case 3: {
                    model = RatStructure.HUT;
                    break;
                }
                case 4: {
                    model = RatStructure.PALACE;
                    break;
                }
                default: {
                    model = RatStructure.TEMPLE;
                    break;
                }
            }
        } else if (chance < 96) {
            switch (rand.nextInt(4)) {
                case 1: {
                    model = RatStructure.SPHINX;
                    break;
                }
                case 2: {
                    model = RatStructure.LINCOLN;
                    break;
                }
                case 3: {
                    model = RatStructure.CHEESE_STATUETTE;
                    break;
                }
                default: {
                    model = RatStructure.HEAD;
                    break;
                }
            }
        } else {
            model = RatStructure.COLOSSUS;
        }
        position = position.func_177982_a(rand.nextInt(8) - 4, 1, rand.nextInt(8) - 4);
        MinecraftServer server = worldIn.func_73046_m();
        BlockPos height = WorldGenRatRuin.getGround(position, worldIn);
        IBlockState dirt = worldIn.func_180495_p(height.func_177979_c(2));
        TemplateManager templateManager = worldIn.func_72860_G().func_186340_h();
        Template template = templateManager.func_186237_a(server, model.structureLoc);
        PlacementSettings settings = new PlacementSettings().func_186220_a(WorldGenRatRuin.getRotationFromFacing(this.facing));
        BlockPos pos = height.func_177967_a(this.facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(this.facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2);
        settings.func_186225_a(Blocks.field_150350_a);
        if (this.checkIfCanGenAt(worldIn, pos, template.func_186259_a().func_177958_n(), template.func_186259_a().func_177952_p(), this.facing)) {
            template.func_189960_a(worldIn, pos, (ITemplateProcessor)new RatsStructureProcessor(0.75f * rand.nextFloat() + 0.75f), settings, 2);
            for (BlockPos underPos : BlockPos.func_177980_a((BlockPos)height.func_177977_b().func_177967_a(this.facing, -template.func_186259_a().func_177952_p() / 2).func_177967_a(this.facing.func_176735_f(), -template.func_186259_a().func_177958_n() / 2), (BlockPos)height.func_177979_c(3).func_177967_a(this.facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(this.facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2))) {
                if (worldIn.func_180495_p(underPos).func_185914_p() || worldIn.func_175623_d(underPos.func_177984_a())) continue;
                worldIn.func_175656_a(underPos, dirt);
                worldIn.func_175656_a(underPos.func_177977_b(), dirt);
                worldIn.func_175656_a(underPos.func_177979_c(2), dirt);
            }
            for (BlockPos vinePos : BlockPos.func_177980_a((BlockPos)height.func_177967_a(this.facing, -template.func_186259_a().func_177952_p() / 2).func_177967_a(this.facing.func_176735_f(), -template.func_186259_a().func_177958_n() / 2), (BlockPos)height.func_177981_b(template.func_186259_a().func_177956_o()).func_177967_a(this.facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(this.facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2))) {
                if (!worldIn.func_180495_p(vinePos).func_185914_p()) continue;
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL.func_179516_a()) {
                    if (worldIn.func_180495_p(vinePos.func_177972_a(enumfacing)).func_185914_p() || worldIn.field_73012_v.nextInt(8) != 0) continue;
                    EnumFacing opposFacing = enumfacing.func_176734_d();
                    IBlockState iblockstate = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(opposFacing == EnumFacing.NORTH)).func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(opposFacing == EnumFacing.EAST)).func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(opposFacing == EnumFacing.SOUTH)).func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(opposFacing == EnumFacing.WEST));
                    worldIn.func_180501_a(vinePos.func_177972_a(enumfacing), iblockstate, 2);
                }
            }
        }
        return true;
    }

    public boolean checkIfCanGenAt(World world, BlockPos middle, int x, int z, EnumFacing facing) {
        return !WorldGenRatRuin.isPartOfRuin(world.func_180495_p(middle.func_177967_a(facing, z / 2))) && !WorldGenRatRuin.isPartOfRuin(world.func_180495_p(middle.func_177967_a(facing.func_176734_d(), z / 2))) && !WorldGenRatRuin.isPartOfRuin(world.func_180495_p(middle.func_177967_a(facing.func_176746_e(), x / 2))) && !WorldGenRatRuin.isPartOfRuin(world.func_180495_p(middle.func_177967_a(facing.func_176735_f(), x / 2)));
    }
}

