/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.gen;

import com.github.alexthe666.rats.server.world.gen.RatStructure;
import com.github.alexthe666.rats.server.world.gen.RatsStructureProcessor;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class WorldGenAquaduct
extends WorldGenerator {
    public EnumFacing facing;
    int aquaDist = 0;

    public WorldGenAquaduct(EnumFacing facing) {
        super(false);
        this.facing = facing;
    }

    public static Rotation getRotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static BlockPos getGround(BlockPos pos, World world) {
        return WorldGenAquaduct.getGround(pos.func_177958_n(), pos.func_177952_p(), world);
    }

    public static BlockPos getGround(int x, int z, World world) {
        BlockPos skyPos = new BlockPos(x, 256, z);
        while ((!world.func_180495_p(skyPos).func_185914_p() || WorldGenAquaduct.canHeightSkipBlock(skyPos, world)) && skyPos.func_177956_o() > 1) {
            skyPos = skyPos.func_177977_b();
        }
        return skyPos;
    }

    private static boolean canHeightSkipBlock(BlockPos pos, World world) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockLog || state.func_177230_c() instanceof BlockLeaves || state.func_177230_c() instanceof BlockLiquid;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        position = position.func_177982_a(rand.nextInt(8) - 4, 1, rand.nextInt(8) - 4);
        BlockPos height = WorldGenAquaduct.getGround(position, worldIn);
        for (int i = 0; i < 2 + rand.nextInt(5); ++i) {
            this.generateAquaduct(worldIn, this.facing, height.func_177967_a(this.facing.func_176746_e(), this.aquaDist));
        }
        return true;
    }

    private void generateAquaduct(World worldIn, EnumFacing facing, BlockPos height) {
        MinecraftServer server = worldIn.func_73046_m();
        IBlockState dirt = worldIn.func_180495_p(height.func_177979_c(2));
        if (!dirt.func_185913_b()) {
            dirt = Blocks.field_150354_m.func_176223_P();
        }
        TemplateManager templateManager = worldIn.func_72860_G().func_186340_h();
        Template template = templateManager.func_186237_a(server, RatStructure.LARGE_AQUADUCT.structureLoc);
        PlacementSettings settings = new PlacementSettings().func_186220_a(WorldGenAquaduct.getRotationFromFacing(facing));
        BlockPos pos = height.func_177967_a(facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2);
        settings.func_186225_a(Blocks.field_150350_a);
        template.func_189960_a(worldIn, pos, (ITemplateProcessor)new RatsStructureProcessor(0.75f * worldIn.field_73012_v.nextFloat() + 0.75f), settings, 2);
        for (BlockPos underPos : BlockPos.func_177980_a((BlockPos)height.func_177977_b().func_177967_a(facing, -template.func_186259_a().func_177952_p() / 2).func_177967_a(facing.func_176735_f(), -template.func_186259_a().func_177958_n() / 2), (BlockPos)height.func_177979_c(3).func_177967_a(facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2))) {
            if (worldIn.func_180495_p(underPos).func_185914_p() || worldIn.func_175623_d(underPos.func_177984_a())) continue;
            worldIn.func_175656_a(underPos, dirt);
            worldIn.func_175656_a(underPos.func_177977_b(), dirt);
            worldIn.func_175656_a(underPos.func_177979_c(2), dirt);
        }
        for (BlockPos vinePos : BlockPos.func_177980_a((BlockPos)height.func_177967_a(facing, -template.func_186259_a().func_177952_p() / 2).func_177967_a(facing.func_176735_f(), -template.func_186259_a().func_177958_n() / 2), (BlockPos)height.func_177981_b(template.func_186259_a().func_177956_o()).func_177967_a(facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2))) {
            if (!worldIn.func_180495_p(vinePos).func_185914_p()) continue;
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL.func_179516_a()) {
                if (worldIn.func_180495_p(vinePos.func_177972_a(enumfacing)).func_185914_p() || worldIn.field_73012_v.nextInt(8) != 0) continue;
                EnumFacing opposFacing = enumfacing.func_176734_d();
                IBlockState iblockstate = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(opposFacing == EnumFacing.NORTH)).func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(opposFacing == EnumFacing.EAST)).func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(opposFacing == EnumFacing.SOUTH)).func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(opposFacing == EnumFacing.WEST));
                worldIn.func_180501_a(vinePos.func_177972_a(enumfacing), iblockstate, 2);
            }
        }
        this.aquaDist += template.func_186259_a().func_177958_n() - 1;
    }
}

