/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class RatAIPickupEnergy
extends EntityAIBase {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private BlockPos targetBlock = null;
    private int feedingTicks;

    public RatAIPickupEnergy(EntityRat entity) {
        this.entity = entity;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!(this.entity.canMove() && this.entity.func_70909_n() && this.canPickUp() && this.entity.func_70638_az() == null && this.entity.getRFTransferRate() != 0)) {
            return false;
        }
        if (this.entity.getHeldRF() >= this.entity.getRFTransferRate()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        this.targetBlock = this.entity.pickupPos;
    }

    private boolean canPickUp() {
        return this.entity.getCommand() == RatCommand.TRANSPORT || this.entity.getCommand() == RatCommand.HARVEST && this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER);
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.getHeldRF() < this.entity.getRFTransferRate();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public boolean canSeeChest() {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_174791_d(), new Vec3d((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5), false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.targetBlock);
        }
        return true;
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.entity.field_70170_p.func_175625_s(this.targetBlock) != null) {
            TileEntity entity = this.entity.field_70170_p.func_175625_s(this.targetBlock);
            this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
            double distance = this.entity.func_70011_f((double)this.targetBlock.func_177958_n() + 0.5, this.targetBlock.func_177956_o() + 1, (double)this.targetBlock.func_177952_p() + 0.5);
            if (distance <= 1.7 && this.canSeeChest()) {
                IEnergyStorage handler = (IEnergyStorage)entity.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
                if (handler == null) {
                    return;
                }
                int howMuchWeWant = this.entity.getRFTransferRate() - this.entity.getHeldRF();
                int recievedEnergy = 0;
                try {
                    howMuchWeWant = Math.min(handler.getEnergyStored(), howMuchWeWant);
                    if (handler.extractEnergy(howMuchWeWant, true) > 0) {
                        recievedEnergy = handler.extractEnergy(howMuchWeWant, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (recievedEnergy <= 0) {
                    this.targetBlock = null;
                    this.func_75251_c();
                } else {
                    this.entity.setHeldRF(this.entity.getHeldRF() + recievedEnergy);
                    this.targetBlock = null;
                    this.func_75251_c();
                }
            }
        }
    }
}

