/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class RatAIHarvestPlacer
extends EntityAIBase {
    private final EntityRat entity;
    private BlockPos targetBlock = null;

    public RatAIHarvestPlacer(EntityRat entity) {
        this.entity = entity;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!(this.entity.canMove() && this.entity.func_70909_n() && this.entity.getCommand() == RatCommand.HARVEST && !this.entity.isInCage() && this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLACER) && this.holdingBlock())) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private boolean holdingBlock() {
        ItemStack stack = this.entity.func_184586_b(EnumHand.MAIN_HAND);
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.holdingBlock() && this.entity.field_70170_p.func_180495_p(this.targetBlock).func_185904_a().func_76222_j();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.holdingBlock()) {
            ItemStack stack = this.entity.func_184586_b(EnumHand.MAIN_HAND);
            ItemBlock blockItem = (ItemBlock)stack.func_77973_b();
            IBlockState block = this.entity.field_70170_p.func_180495_p(this.targetBlock);
            BlockPos moveToPos = this.targetBlock;
            this.entity.func_70661_as().func_75492_a((double)moveToPos.func_177958_n() + 0.5, (double)moveToPos.func_177956_o(), (double)moveToPos.func_177952_p() + 0.5, 1.0);
            if (blockItem.func_179223_d().func_176196_c(this.entity.field_70170_p, this.targetBlock) && this.entity.field_70170_p.func_190527_a(blockItem.func_179223_d(), this.targetBlock, false, EnumFacing.UP, (Entity)null)) {
                double distance = this.entity.func_70011_f(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                if (distance < 1.5) {
                    ItemStack seedStack = this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77946_l();
                    seedStack.func_190920_e(1);
                    this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190918_g(1);
                    IBlockState iblockstate1 = blockItem.func_179223_d().getStateForPlacement(this.entity.field_70170_p, this.targetBlock, this.entity.func_174811_aO(), 0.0f, 0.0f, 0.0f, stack.func_77960_j(), (EntityLivingBase)this.entity, EnumHand.MAIN_HAND);
                    this.entity.field_70170_p.func_175656_a(this.targetBlock, iblockstate1);
                    if (this.entity.func_70094_T()) {
                        this.entity.func_70107_b(this.entity.field_70165_t, this.entity.field_70163_u + 1.0, this.entity.field_70161_v);
                    }
                    SoundType placeSound = iblockstate1.func_177230_c().getSoundType(iblockstate1, this.entity.field_70170_p, this.targetBlock, (Entity)this.entity);
                    this.entity.func_184185_a(placeSound.func_185841_e(), (placeSound.func_185843_a() + 1.0f) / 2.0f, placeSound.func_185847_b() * 0.8f);
                    this.targetBlock = null;
                    this.func_75251_c();
                }
            } else {
                this.targetBlock = null;
                this.func_75251_c();
            }
        }
    }

    private void resetTarget() {
        BlockPos newTarget = null;
        if (this.entity.func_110175_bO() && !this.entity.field_70170_p.func_180495_p(newTarget = this.entity.func_180486_cf()).func_185904_a().func_76222_j()) {
            newTarget = newTarget.func_177984_a();
        }
        if (newTarget != null) {
            this.targetBlock = newTarget;
        }
    }
}

