/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.server.entity.EntityCheeseCannonball;
import com.github.alexthe666.rats.server.entity.EntityPirat;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.entity.ai.PiratBoatPathNavigate;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPiratBoat
extends EntityMob
implements IRatlantean {
    public static final ItemStack BANNER = EntityPiratBoat.generateBanner();
    private static final List<ItemStack> EMPTY_EQUIPMENT = Collections.emptyList();
    private static final DataParameter<Boolean> FIRING = EntityDataManager.func_187226_a(EntityPiratBoat.class, (DataSerializer)DataSerializers.field_187198_h);
    private final float[] paddlePositions = new float[2];
    protected int navigatorType;
    private boolean prevFire;
    private int fireCooldown = 0;
    private double waterLevel;
    private EntityBoat.Status status;
    private EntityBoat.Status previousStatus;
    private double lastYd;

    public EntityPiratBoat(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.75f, 0.8f);
        this.switchNavigator(0);
    }

    private static ItemStack generateBanner() {
        NBTTagList patterns = new NBTTagList();
        NBTTagCompound currentPattern = new NBTTagCompound();
        currentPattern.func_74778_a("Pattern", "rats.rat_and_crossbones");
        currentPattern.func_74768_a("Color", 15);
        patterns.func_74742_a((NBTBase)currentPattern);
        return ItemBanner.func_190910_a((EnumDyeColor)EnumDyeColor.BLACK, (NBTTagList)patterns);
    }

    protected void switchNavigator(int type) {
        if (type == 1) {
            this.field_70699_by = new PathNavigateGround((EntityLiving)this, this.field_70170_p);
            this.navigatorType = 1;
        } else {
            this.field_70699_by = new PiratBoatPathNavigate((EntityLiving)this, this.field_70170_p);
            this.navigatorType = 0;
        }
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        String s = this.func_70022_Q();
        compound.func_74778_a("id", s);
        this.func_189511_e(compound);
        return true;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public Entity func_184179_bs() {
        if (!this.func_184188_bt().isEmpty()) {
            for (Entity entity : this.func_184188_bt()) {
                if (!(entity instanceof EntityPirat)) continue;
                return entity;
            }
        }
        return null;
    }

    public double func_70033_W() {
        return 0.45;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        passenger.func_70107_b(this.field_70165_t, this.field_70163_u + 0.45, this.field_70161_v);
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRING, (Object)false);
    }

    public boolean isFiring() {
        return (Boolean)this.field_70180_af.func_187225_a(FIRING);
    }

    public void setFiring(boolean male) {
        this.field_70180_af.func_187227_b(FIRING, (Object)male);
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        this.field_70181_x *= 0.6;
        this.field_70757_a = 20;
        if (this.field_70725_aQ >= 80) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                int j;
                for (j = 0; j < this.field_70146_Z.nextInt(3); ++j) {
                    this.func_70099_a(new ItemStack(Items.field_151055_y), 0.0f);
                }
                for (j = 0; j < this.field_70146_Z.nextInt(3); ++j) {
                    this.func_70099_a(new ItemStack(Blocks.field_150344_f), 0.0f);
                }
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70099_a(BANNER.func_77946_l(), 0.0f);
                }
                if (this.field_70146_Z.nextInt(2) == 0) {
                    this.func_70099_a(new ItemStack(RatsItemRegistry.CHEESE_CANNONBALL), 0.0f);
                }
            }
            this.func_70106_y();
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    public void func_70071_h_() {
        boolean groundNavigate;
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        super.func_70071_h_();
        boolean bl = groundNavigate = !this.func_70090_H() && this.status != EntityBoat.Status.IN_WATER;
        if (!this.field_70170_p.field_72995_K) {
            if (groundNavigate && this.navigatorType != 1) {
                this.switchNavigator(1);
            }
            if (!groundNavigate && this.navigatorType != 0) {
                this.switchNavigator(0);
            }
        }
        if (this.func_184187_bx() != null && !this.func_184187_bx().func_184218_aH()) {
            this.func_184187_bx().func_184205_a((Entity)this, true);
        }
        if (this.prevFire != this.isFiring()) {
            this.fireCooldown = 4;
        }
        if (this.isFiring() && this.fireCooldown == 0) {
            this.setFiring(false);
        }
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
        this.prevFire = this.isFiring();
        if (!this.func_184207_aI() && !this.field_70170_p.field_72995_K) {
            this.func_70097_a(DamageSource.field_76369_e, 1000.0f);
        }
        if (this.func_184179_bs() != null) {
            this.updateMotion();
            if (this.func_184179_bs() instanceof EntityLiving) {
                EntityLiving riding = (EntityLiving)this.func_184179_bs();
                this.field_70702_br = riding.field_70702_br;
                this.field_191988_bg = riding.field_191988_bg;
                this.func_191958_b(this.field_70702_br, 0.0f, this.field_191988_bg, 0.1f);
                this.field_70177_z = riding.field_70177_z;
                this.field_70759_as = riding.field_70759_as;
                this.field_70126_B = riding.field_70126_B;
            }
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelectors.func_188442_a((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof EntityPlayer);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.field_70130_N < this.field_70130_N && entity instanceof EntityPirat) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(0.1);
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof EntityBoat) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    protected void func_71061_d_() {
    }

    @SideOnly(value=Side.CLIENT)
    public float getRowingTime(int side, float limbSwing) {
        return (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[side] - (double)0.3926991f), (double)this.paddlePositions[side], (double)limbSwing);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return EMPTY_EQUIPMENT;
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    public void shoot(EntityPirat pirat) {
        EntityLivingBase target = pirat.func_70638_az();
        if (target == null) {
            target = this.field_70170_p.func_184136_b((Entity)this, 30.0);
        }
        if (target != null) {
            double d0 = target.field_70165_t - this.field_70165_t;
            double d2 = target.field_70161_v - this.field_70161_v;
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            this.field_70761_aq = this.field_70177_z = f % 360.0f;
            EntityCheeseCannonball cannonball = new EntityCheeseCannonball(this.field_70170_p, (EntityLivingBase)pirat);
            cannonball.field_184539_c = this;
            float radius = 1.6f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.field_70165_t;
            double extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.field_70161_v;
            double extraY = 0.8 + this.field_70163_u;
            double d02 = target.field_70163_u + (double)target.func_70047_e();
            double d1 = target.field_70165_t - extraX;
            double d3 = target.field_70161_v - extraZ;
            double d22 = d02 - extraY;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.65f;
            float velocity = this.func_70032_d((Entity)target) * 0.045f;
            cannonball.func_70107_b(extraX, extraY, extraZ);
            cannonball.func_70186_c(d1, d22 + (double)f2, d3, velocity, 0.4f);
            this.func_184185_a(SoundEvents.field_187539_bB, 3.0f, 2.3f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)cannonball);
            }
            this.setFiring(true);
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getWaterLevelAbove() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            float f1;
            block4: for (int k1 = k; k1 < l; ++k1) {
                float f = 0.0f;
                int l1 = i;
                while (true) {
                    if (l1 >= j) {
                        float f2;
                        if (!(f < 1.0f)) continue block4;
                        float f3 = f2 = (float)blockpos$pooledmutableblockpos.func_177956_o() + f;
                        return f3;
                    }
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(l1, k1, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (iblockstate.func_185904_a() == Material.field_151586_h) {
                            f = Math.max(f, BlockLiquid.func_190973_f((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos));
                        }
                        if (f >= 1.0f) continue block4;
                    }
                    ++l1;
                }
            }
            float f = f1 = (float)(l + 1);
            return f;
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)(axisalignedbb.field_72338_b - 0.5));
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (iblockstate.func_185904_a() != Material.field_151586_h) continue;
                        float f = BlockLiquid.func_190972_g((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos);
                        this.waterLevel = Math.max((double)f, this.waterLevel);
                        flag |= axisalignedbb.field_72338_b < (double)f;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return flag || this.func_191953_am();
    }

    private EntityBoat.Status getBoatStatus() {
        EntityBoat.Status entityboat$status = this.getUnderwaterStatus();
        if (entityboat$status != null) {
            this.waterLevel = this.func_174813_aQ().field_72338_b;
            return entityboat$status;
        }
        if (this.checkInWater()) {
            return EntityBoat.Status.IN_WATER;
        }
        return EntityBoat.Status.ON_LAND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private EntityBoat.Status getUnderwaterStatus() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (iblockstate.func_185904_a() != Material.field_151586_h || !(d0 < (double)BlockLiquid.func_190972_g((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos))) continue;
                        if ((Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                            EntityBoat.Status entityboat$status;
                            EntityBoat.Status status = entityboat$status = EntityBoat.Status.UNDER_FLOWING_WATER;
                            return status;
                        }
                        flag = true;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return flag ? EntityBoat.Status.UNDER_WATER : null;
    }

    private void updateMotion() {
        double d0 = -0.04f;
        double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        float momentum = 0.05f;
        if (this.previousStatus == EntityBoat.Status.IN_AIR && this.status != EntityBoat.Status.IN_AIR && this.status != EntityBoat.Status.ON_LAND) {
            this.waterLevel = this.func_174813_aQ().field_72338_b + (double)this.field_70131_O;
            this.func_70107_b(this.field_70165_t, (double)(this.getWaterLevelAbove() - this.field_70131_O) + 0.101, this.field_70161_v);
            this.field_70181_x = 0.0;
            this.lastYd = 0.0;
            this.status = EntityBoat.Status.IN_WATER;
        } else {
            double up1 = this.waterLevel + 1.5;
            double up2 = this.func_174813_aQ().field_72338_b + 0.5;
            if (this.status == EntityBoat.Status.IN_WATER) {
                d2 = (up1 - up2) / (double)this.field_70131_O;
                momentum = 0.9f;
            } else if (this.status == EntityBoat.Status.UNDER_FLOWING_WATER) {
                d2 = (up1 - up2) / (double)this.field_70131_O;
                momentum = 0.9f;
            } else if (this.status == EntityBoat.Status.UNDER_WATER) {
                d2 = (up1 - up2) / (double)this.field_70131_O;
                momentum = 0.45f;
            } else if (this.status == EntityBoat.Status.IN_AIR) {
                momentum = 0.9f;
                this.field_70181_x += d1;
            } else if (this.status == EntityBoat.Status.ON_LAND) {
                momentum = 0.0f;
                this.field_70181_x += d1;
            }
            if (d2 > 0.0) {
                this.field_70181_x += d2 * 0.06153846016296973;
                this.field_70181_x *= 0.75;
            }
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187881_gQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187881_gQ;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW() && (this.func_70090_H() || this.status == EntityBoat.Status.IN_WATER)) {
            float forwards = forward;
            float strafes = strafe * 0.5f;
            this.func_191958_b(forwards, vertical, strafes, 0.0f);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.func_70090_H() ? this.field_70181_x : 0.0, this.field_70179_y);
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }
}

