/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.BlockRatCage;
import com.github.alexthe666.rats.server.blocks.ICustomRendered;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatTube;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRatTube
extends BlockContainer
implements ICustomRendered {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool OPEN_NORTH = PropertyBool.func_177716_a((String)"open_north");
    public static final PropertyBool OPEN_EAST = PropertyBool.func_177716_a((String)"open_east");
    public static final PropertyBool OPEN_SOUTH = PropertyBool.func_177716_a((String)"open_south");
    public static final PropertyBool OPEN_WEST = PropertyBool.func_177716_a((String)"open_west");
    public static final PropertyBool OPEN_UP = PropertyBool.func_177716_a((String)"open_up");
    public static final PropertyBool OPEN_DOWN = PropertyBool.func_177716_a((String)"open_down");
    public static final PropertyBool[] ALL_OPEN_PROPS = new PropertyBool[]{OPEN_DOWN, OPEN_UP, OPEN_NORTH, OPEN_SOUTH, OPEN_WEST, OPEN_EAST};
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB((double)0.2f, (double)0.8f, (double)0.2f, (double)0.8f, (double)0.8f, (double)0.8f);
    private static final AxisAlignedBB UP_AABB_CONNECT_1 = new AxisAlignedBB((double)0.2f, (double)0.8f, (double)0.2f, (double)0.8f, 1.0, (double)0.2f);
    private static final AxisAlignedBB UP_AABB_CONNECT_2 = new AxisAlignedBB((double)0.2f, (double)0.8f, (double)0.2f, (double)0.2f, 1.0, (double)0.8f);
    private static final AxisAlignedBB UP_AABB_CONNECT_3 = new AxisAlignedBB((double)0.8f, (double)0.8f, (double)0.2f, (double)0.8f, 1.0, (double)0.8f);
    private static final AxisAlignedBB UP_AABB_CONNECT_4 = new AxisAlignedBB((double)0.2f, (double)0.8f, (double)0.8f, (double)0.8f, 1.0, (double)0.8f);
    private static final AxisAlignedBB INTERACT_AABB_CENTER = new AxisAlignedBB((double)0.2f, (double)0.2f, (double)0.2f, (double)0.8f, (double)0.8f, (double)0.8f);
    private static final AxisAlignedBB INTERACT_AABB_UP = new AxisAlignedBB((double)0.2f, (double)0.8f, (double)0.2f, (double)0.8f, 1.0, (double)0.8f);
    private static final AxisAlignedBB INTERACT_AABB_DOWN = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.2f, (double)0.8f);
    private static final AxisAlignedBB INTERACT_AABB_SOUTH = new AxisAlignedBB((double)0.2f, (double)0.2f, (double)0.8f, (double)0.8f, (double)0.8f, 1.0);
    private static final AxisAlignedBB INTERACT_AABB_NORTH = new AxisAlignedBB((double)0.2f, (double)0.2f, 0.0, (double)0.8f, (double)0.8f, (double)0.2f);
    private static final AxisAlignedBB INTERACT_AABB_WEST = new AxisAlignedBB(0.0, (double)0.2f, (double)0.2f, (double)0.2f, (double)0.8f, (double)0.8f);
    private static final AxisAlignedBB INTERACT_AABB_EAST = new AxisAlignedBB((double)0.8f, (double)0.2f, (double)0.2f, 1.0, (double)0.8f, (double)0.8f);
    private static Map<EnumFacing, AxisAlignedBB> AABB_MAP = new HashMap<EnumFacing, AxisAlignedBB>();
    private static Map<EnumFacing, AxisAlignedBB> AABB_CONNECTOR_1_MAP = new HashMap<EnumFacing, AxisAlignedBB>();
    private static Map<EnumFacing, AxisAlignedBB> AABB_CONNECTOR_2_MAP = new HashMap<EnumFacing, AxisAlignedBB>();
    private static Map<EnumFacing, AxisAlignedBB> AABB_CONNECTOR_3_MAP = new HashMap<EnumFacing, AxisAlignedBB>();
    private static Map<EnumFacing, AxisAlignedBB> AABB_CONNECTOR_4_MAP = new HashMap<EnumFacing, AxisAlignedBB>();

    public BlockRatTube(String name) {
        super(Material.field_151592_s);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(RatsMod.TAB);
        this.func_149663_c("rats.rat_tube_" + name);
        this.setRegistryName("rats", "rat_tube_" + name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN_NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN_EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN_SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN_WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN_UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN_DOWN, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        GameRegistry.registerTileEntity(TileEntityRatTube.class, (String)"rat_tube");
    }

    public static AxisAlignedBB rotateAABB(AxisAlignedBB aabb, EnumFacing facing) {
        switch (facing) {
            case UP: {
                return aabb;
            }
            case DOWN: {
                return new AxisAlignedBB(aabb.field_72340_a, 1.0 - aabb.field_72337_e, aabb.field_72339_c, aabb.field_72336_d, 1.0 - aabb.field_72338_b, aabb.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72339_c, 1.0 - aabb.field_72337_e, aabb.field_72336_d, aabb.field_72334_f, 1.0 - aabb.field_72338_b);
            }
            case SOUTH: {
                return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72339_c, aabb.field_72338_b, aabb.field_72336_d, aabb.field_72334_f, aabb.field_72337_e);
            }
            case EAST: {
                return new AxisAlignedBB(aabb.field_72338_b, aabb.field_72340_a, aabb.field_72339_c, aabb.field_72337_e, aabb.field_72336_d, aabb.field_72334_f);
            }
            case WEST: {
                return new AxisAlignedBB(1.0 - aabb.field_72337_e, aabb.field_72340_a, aabb.field_72339_c, 1.0 - aabb.field_72338_b, aabb.field_72336_d, aabb.field_72334_f);
            }
        }
        return aabb;
    }

    public List<AxisAlignedBB> compileAABBList(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        ArrayList<AxisAlignedBB> aabbs = new ArrayList<AxisAlignedBB>();
        aabbs.add(INTERACT_AABB_CENTER);
        if (state.func_177230_c() instanceof BlockRatTube) {
            IBlockState actualState = this.func_176221_a(state, worldIn, pos);
            if (((Boolean)actualState.func_177229_b((IProperty)UP)).booleanValue()) {
                aabbs.add(INTERACT_AABB_UP);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)DOWN)).booleanValue()) {
                aabbs.add(INTERACT_AABB_DOWN);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)EAST)).booleanValue()) {
                aabbs.add(INTERACT_AABB_EAST);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)WEST)).booleanValue()) {
                aabbs.add(INTERACT_AABB_WEST);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)NORTH)).booleanValue()) {
                aabbs.add(INTERACT_AABB_NORTH);
            }
            if (((Boolean)actualState.func_177229_b((IProperty)SOUTH)).booleanValue()) {
                aabbs.add(INTERACT_AABB_SOUTH);
            }
        }
        return aabbs;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (state.func_177230_c() instanceof BlockRatTube) {
            IBlockState actualState = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
            if (!((Boolean)actualState.func_177229_b((IProperty)UP)).booleanValue() && !((Boolean)actualState.func_177229_b((IProperty)OPEN_UP)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB, EnumFacing.UP, AABB_MAP));
            }
            if (!((Boolean)actualState.func_177229_b((IProperty)DOWN)).booleanValue() && !((Boolean)actualState.func_177229_b((IProperty)OPEN_DOWN)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB, EnumFacing.DOWN, AABB_MAP));
            }
            if (!((Boolean)actualState.func_177229_b((IProperty)NORTH)).booleanValue() && !((Boolean)actualState.func_177229_b((IProperty)OPEN_NORTH)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB, EnumFacing.NORTH, AABB_MAP));
            }
            if (!((Boolean)actualState.func_177229_b((IProperty)SOUTH)).booleanValue() && !((Boolean)actualState.func_177229_b((IProperty)OPEN_SOUTH)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB, EnumFacing.SOUTH, AABB_MAP));
            }
            if (!((Boolean)actualState.func_177229_b((IProperty)EAST)).booleanValue() && !((Boolean)actualState.func_177229_b((IProperty)OPEN_EAST)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB, EnumFacing.EAST, AABB_MAP));
            }
            if (!((Boolean)actualState.func_177229_b((IProperty)WEST)).booleanValue() && !((Boolean)actualState.func_177229_b((IProperty)OPEN_WEST)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB, EnumFacing.WEST, AABB_MAP));
            }
            if (((Boolean)actualState.func_177229_b((IProperty)UP)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_1, EnumFacing.UP, AABB_CONNECTOR_1_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_2, EnumFacing.UP, AABB_CONNECTOR_2_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_3, EnumFacing.UP, AABB_CONNECTOR_3_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_4, EnumFacing.UP, AABB_CONNECTOR_4_MAP));
            }
            if (((Boolean)actualState.func_177229_b((IProperty)DOWN)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_1, EnumFacing.DOWN, AABB_CONNECTOR_1_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_2, EnumFacing.DOWN, AABB_CONNECTOR_2_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_3, EnumFacing.DOWN, AABB_CONNECTOR_3_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_4, EnumFacing.DOWN, AABB_CONNECTOR_4_MAP));
            }
            if (((Boolean)actualState.func_177229_b((IProperty)NORTH)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_1, EnumFacing.NORTH, AABB_CONNECTOR_1_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_2, EnumFacing.NORTH, AABB_CONNECTOR_2_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_3, EnumFacing.NORTH, AABB_CONNECTOR_3_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_4, EnumFacing.NORTH, AABB_CONNECTOR_4_MAP));
            }
            if (((Boolean)actualState.func_177229_b((IProperty)SOUTH)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_1, EnumFacing.SOUTH, AABB_CONNECTOR_1_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_2, EnumFacing.SOUTH, AABB_CONNECTOR_2_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_3, EnumFacing.SOUTH, AABB_CONNECTOR_3_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_4, EnumFacing.SOUTH, AABB_CONNECTOR_4_MAP));
            }
            if (((Boolean)actualState.func_177229_b((IProperty)EAST)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_1, EnumFacing.EAST, AABB_CONNECTOR_1_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_2, EnumFacing.EAST, AABB_CONNECTOR_2_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_3, EnumFacing.EAST, AABB_CONNECTOR_3_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_4, EnumFacing.EAST, AABB_CONNECTOR_4_MAP));
            }
            if (((Boolean)actualState.func_177229_b((IProperty)WEST)).booleanValue()) {
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_1, EnumFacing.WEST, AABB_CONNECTOR_1_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_2, EnumFacing.WEST, AABB_CONNECTOR_2_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_3, EnumFacing.WEST, AABB_CONNECTOR_3_MAP));
                BlockRatTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotateWithMap(UP_AABB_CONNECT_4, EnumFacing.WEST, AABB_CONNECTOR_4_MAP));
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        List<AxisAlignedBB> aabbs = this.compileAABBList(source, pos, state);
        AxisAlignedBB bb = new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5);
        for (AxisAlignedBB box : aabbs) {
            bb = bb.func_111270_a(box);
        }
        return bb;
    }

    public AxisAlignedBB rotateWithMap(AxisAlignedBB aabb, EnumFacing facing, Map<EnumFacing, AxisAlignedBB> checkMap) {
        if (checkMap.get(facing) == null) {
            AxisAlignedBB newAABB = BlockRatTube.rotateAABB(aabb, facing);
            checkMap.put(facing, newAABB);
            return newAABB;
        }
        return checkMap.get(facing);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, 1);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        for (EnumFacing side : EnumFacing.values()) {
            PropertyBool changing;
            IBlockState sideState = worldIn.func_180495_p(pos.func_177972_a(side));
            switch (side) {
                case NORTH: {
                    changing = OPEN_NORTH;
                    break;
                }
                case SOUTH: {
                    changing = OPEN_SOUTH;
                    break;
                }
                case EAST: {
                    changing = OPEN_EAST;
                    break;
                }
                case WEST: {
                    changing = OPEN_WEST;
                    break;
                }
                case DOWN: {
                    changing = OPEN_DOWN;
                    break;
                }
                default: {
                    changing = OPEN_UP;
                }
            }
            if (!((Boolean)state.func_177229_b((IProperty)changing)).booleanValue() || this.canBeOpenNextToBlock(worldIn, sideState)) continue;
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)changing, (Comparable)Boolean.valueOf(false)));
            this.updateTEOpening(worldIn, pos, side, false);
        }
    }

    private boolean canBeOpenNextToBlock(World worldIn, IBlockState sideState) {
        return !(sideState.func_177230_c() instanceof BlockRatTube);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, OPEN_NORTH, OPEN_SOUTH, OPEN_EAST, OPEN_WEST, OPEN_UP, OPEN_DOWN});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.WEST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canFenceConnectTo(worldIn, pos, EnumFacing.DOWN)));
    }

    private boolean canFenceConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        return world.func_180495_p(other).func_177230_c() instanceof BlockRatCage || world.func_180495_p(other).func_177230_c() instanceof BlockRatTube;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > 0) {
            PropertyBool openSide = ALL_OPEN_PROPS[MathHelper.func_76125_a((int)(meta - 1), (int)0, (int)(ALL_OPEN_PROPS.length - 1))];
            return this.func_176223_P().func_177226_a((IProperty)openSide, (Comparable)Boolean.valueOf(true));
        }
        return super.func_176203_a(meta);
    }

    public int func_176201_c(IBlockState state) {
        for (int i = 0; i < ALL_OPEN_PROPS.length; ++i) {
            if (!((Boolean)state.func_177229_b((IProperty)ALL_OPEN_PROPS[i])).booleanValue()) continue;
            return i + 1;
        }
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        PropertyBool changing;
        if (playerIn.func_70093_af() || playerIn.func_184586_b(hand).func_77973_b() instanceof ItemBlock) {
            return false;
        }
        PropertyBool[] allOpenVars = new PropertyBool[]{OPEN_DOWN, OPEN_EAST, OPEN_NORTH, OPEN_SOUTH, OPEN_UP, OPEN_WEST};
        switch (side) {
            case NORTH: {
                changing = OPEN_NORTH;
                break;
            }
            case SOUTH: {
                changing = OPEN_SOUTH;
                break;
            }
            case EAST: {
                changing = OPEN_EAST;
                break;
            }
            case WEST: {
                changing = OPEN_WEST;
                break;
            }
            case DOWN: {
                changing = OPEN_DOWN;
                break;
            }
            default: {
                changing = OPEN_UP;
            }
        }
        boolean alreadyOpened = false;
        for (PropertyBool opened : allOpenVars) {
            if (!((Boolean)state.func_177229_b((IProperty)opened)).booleanValue()) continue;
            alreadyOpened = true;
        }
        if (!alreadyOpened && this.canBeOpenNextToBlock(worldIn, worldIn.func_180495_p(pos.func_177972_a(side)))) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)changing, (Comparable)Boolean.valueOf(true)));
            this.updateTEOpening(worldIn, pos, side, true);
        } else {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)OPEN_NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN_EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN_SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN_WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN_UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN_DOWN, (Comparable)Boolean.valueOf(false)));
            this.updateTEOpening(worldIn, pos, side, false);
        }
        return true;
    }

    private void updateTEOpening(World world, BlockPos pos, EnumFacing side, boolean open) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityRatTube) {
            TileEntityRatTube te = (TileEntityRatTube)world.func_175625_s(pos);
            te.setEntranceData(side, open);
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityRatTube();
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isOpenAtAll(IBlockState state) {
        return this.func_176201_c(state) > 0;
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tile.rats.rat_tube.desc0", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tile.rats.rat_tube.desc1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tile.rats.rat_tube.desc2", (Object[])new Object[0]));
    }
}

