/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.storagesack;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.BaseItem;
import com.lothrazar.cyclicmagic.item.storagesack.BagDepositReturn;
import com.lothrazar.cyclicmagic.item.storagesack.InventoryStorage;
import com.lothrazar.cyclicmagic.item.storagesack.StorageActionType;
import com.lothrazar.cyclicmagic.item.storagesack.StoragePickupType;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStorageBag
extends BaseItem
implements IHasRecipe {
    private static final String GUI_ID = "guiID";

    public ItemStorageBag() {
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        int size = InventoryStorage.countNonEmpty(stack);
        tooltip.add(UtilChat.lang("item.storage_bag.tooltip") + size);
        tooltip.add(UtilChat.lang("item.storage_bag.tooltip2") + UtilChat.lang(StorageActionType.getName(stack)));
        tooltip.add(UtilChat.lang(StoragePickupType.getName(stack)));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        StorageActionType.tickTimeout(stack);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @SubscribeEvent
    public void onEntityItemPickupEvent(EntityItemPickupEvent event) {
        if (event.getItem().field_70128_L) {
            return;
        }
        ItemStack stackOnGround = event.getItem().func_92059_d();
        if (!this.canPickup(stackOnGround)) {
            return;
        }
        NonNullList<ItemStack> foundBags = this.findAmmoList(event.getEntityPlayer(), this);
        for (ItemStack stackIsBag : foundBags) {
            if (StorageActionType.getIsOpen(stackIsBag)) {
                return;
            }
            int pickupType = StoragePickupType.get(stackIsBag);
            if (pickupType == StoragePickupType.NOTHING.ordinal()) continue;
            if (pickupType == StoragePickupType.FILTER.ordinal()) {
                boolean doesMatch = false;
                NonNullList<ItemStack> inv = InventoryStorage.readFromNBT(stackIsBag);
                for (ItemStack tryMatch : inv) {
                    if (!tryMatch.func_185136_b(stackOnGround)) continue;
                    doesMatch = true;
                    break;
                }
                if (!doesMatch) {
                    return;
                }
            }
            InventoryStorage inventoryBag = new InventoryStorage(event.getEntityPlayer(), stackIsBag);
            NonNullList onGround = NonNullList.func_191196_a();
            onGround.add((Object)stackOnGround);
            BagDepositReturn ret = UtilInventoryTransfer.dumpFromListToIInventory(event.getEntity().field_70170_p, inventoryBag, (NonNullList<ItemStack>)onGround, false);
            if (((ItemStack)ret.stacks.get(0)).func_190926_b()) {
                event.getItem().func_70106_y();
                event.setCanceled(true);
                break;
            }
            event.getItem().func_92058_a((ItemStack)ret.stacks.get(0));
            break;
        }
    }

    private boolean canPickup(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != this;
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        World world;
        TileEntity tile;
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held != null && held.func_77973_b() == this && (tile = (world = event.getWorld()).func_175625_s(event.getPos())) != null) {
            int depositType = StorageActionType.get(held);
            if (depositType == StorageActionType.NOTHING.ordinal()) {
                if (world.field_72995_K) {
                    UtilChat.addChatMessage(player, UtilChat.lang("item.storage_bag.disabled"));
                }
                return;
            }
            if (!world.field_72995_K) {
                NonNullList<ItemStack> inv = InventoryStorage.readFromNBT(held);
                boolean onlyMatchingItems = depositType == StorageActionType.MERGE.ordinal();
                BagDepositReturn ret = UtilInventoryTransfer.dumpFromListToCapability(world, tile, event.getFace(), inv, onlyMatchingItems);
                if (ret != null && ret.moved > 0) {
                    InventoryStorage.writeToNBT(held, ret.stacks);
                    UtilChat.addChatMessage(player, UtilChat.lang("item.storage_bag.success") + ret.moved);
                }
            }
            UtilSound.playSound(player, SoundRegistry.sack_holding);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack wand = player.func_184586_b(hand);
        this.setIdIfEmpty(wand);
        UtilSound.playSound(player, player.func_180425_c(), SoundEvents.field_187706_dO, SoundCategory.PLAYERS, 0.1f);
        if (!world.field_72995_K && wand.func_77973_b() instanceof ItemStorageBag && hand == EnumHand.MAIN_HAND && wand.func_190916_E() == 1) {
            BlockPos pos = player.func_180425_c();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            player.openGui((Object)ModCyclic.instance, 3, world, x, y, z);
        }
        return super.func_77659_a(world, player, hand);
    }

    private void setIdIfEmpty(ItemStack wand) {
        if (!UtilNBT.getItemStackNBT(wand).func_74764_b(GUI_ID) || UtilNBT.getItemStackNBT(wand).func_74779_i(GUI_ID) == null) {
            UtilNBT.setItemStackNBTVal(wand, GUI_ID, UUID.randomUUID().toString());
        }
    }

    public static String getId(ItemStack wand) {
        return UtilNBT.getItemStackNBT(wand).func_74779_i(GUI_ID);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "lsl", "ldl", "lrl", Character.valueOf('l'), "leather", Character.valueOf('s'), "string", Character.valueOf('r'), "dustRedstone", Character.valueOf('d'), "ingotGold");
    }
}

