/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.minecart;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.minecart.FakeWorld;
import java.util.Random;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerDispenser;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityGoldMinecartDispenser
extends EntityMinecartChest {
    private static final int TIME_BTW_DROPS = 40;
    private int timeSinceDropped = 0;
    private FakeWorld fakeWorld;

    public EntityGoldMinecartDispenser(World worldIn) {
        super(worldIn);
        this.fakeWorld = new FakeWorld(worldIn, this);
        this.func_174899_a(this.func_180457_u());
    }

    public EntityGoldMinecartDispenser(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.fakeWorld = new FakeWorld(worldIn, this);
        this.func_174899_a(this.func_180457_u());
    }

    public int func_70302_i_() {
        return 9;
    }

    public IBlockState func_180457_u() {
        return Blocks.field_150367_z.func_176223_P();
    }

    public IBlockState func_174897_t() {
        IBlockState s = super.func_174897_t();
        return s;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("tdr", this.timeSinceDropped);
        super.func_70014_b(compound);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.timeSinceDropped = compound.func_74762_e("tdr");
        super.func_70037_a(compound);
    }

    public String func_174875_k() {
        return "minecraft:dispenser";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184288_f(playerIn);
        return new ContainerDispenser((IInventory)playerInventory, (IInventory)this);
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
        if (receivingPower) {
            this.dispense(this.fakeWorld, new BlockPos(x, y, z));
        }
    }

    protected void dispense(World worldIn, BlockPos pos) {
        if (this.timeSinceDropped > 0) {
            --this.timeSinceDropped;
            return;
        }
        BlockSourceImpl source = new BlockSourceImpl(worldIn, pos);
        int i = this.getDispenseSlot(worldIn.field_73012_v);
        if (i < 0) {
            this.field_70170_p.func_175718_b(1001, pos, 0);
            this.timeSinceDropped = 40;
        } else {
            ItemStack itemstack = this.func_70301_a(i);
            IBehaviorDispenseItem ibehaviordispenseitem = this.getBehavior(itemstack);
            try {
                ItemStack result = ibehaviordispenseitem.func_82482_a((IBlockSource)source, itemstack);
                this.func_70299_a(i, result);
                this.timeSinceDropped = 40;
            }
            catch (Exception e) {
                ModCyclic.logger.error("Minecart dispenser error ", e);
            }
        }
    }

    public int getDispenseSlot(Random rand) {
        int i = -1;
        int j = 1;
        for (int k = 0; k < this.func_70302_i_(); ++k) {
            if (this.func_70301_a(k).func_190926_b() || rand.nextInt(j++) != 0) continue;
            i = k;
        }
        return i;
    }

    protected IBehaviorDispenseItem getBehavior(ItemStack stack) {
        return (IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)stack.func_77973_b());
    }

    protected void func_180460_a(BlockPos pos, IBlockState state) {
        BlockRailBase blockrailbase = (BlockRailBase)state.func_177230_c();
        if (blockrailbase != Blocks.field_150408_cc) {
            this.timeSinceDropped = 0;
        }
        BlockRailBase.EnumRailDirection raildirection = blockrailbase.getRailDirection((IBlockAccess)this.field_70170_p, pos, state, (EntityMinecart)this);
        EnumFacing fac = null;
        switch (raildirection) {
            case ASCENDING_EAST: {
                fac = EnumFacing.EAST;
                break;
            }
            case ASCENDING_WEST: {
                fac = EnumFacing.WEST;
                break;
            }
            case ASCENDING_NORTH: {
                fac = EnumFacing.NORTH;
                break;
            }
            case ASCENDING_SOUTH: {
                fac = EnumFacing.SOUTH;
            }
            case EAST_WEST: {
                fac = this.field_70159_w > 0.0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
                break;
            }
            case NORTH_SOUTH: {
                fac = this.field_70179_y < 0.0 ? EnumFacing.WEST : EnumFacing.EAST;
                break;
            }
        }
        super.func_180460_a(pos, state);
        if (fac != null) {
            this.func_174899_a(this.func_180457_u().func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)fac));
        }
    }
}

