/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.equipbauble;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipeAndRepair;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseCharm;
import com.lothrazar.cyclicmagic.potion.PotionEffectRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.common.config.Configuration;

public class ItemCharmSlowfall
extends BaseCharm
implements IHasRecipeAndRepair,
IContent {
    private static final int seconds = 30;
    private static final int fallDistanceLimit = 6;
    private static final int durability = 64;
    private static final Potion potion = PotionEffectRegistry.SLOWFALL;
    private static final ItemStack craftItem = new ItemStack(Items.field_179556_br);
    private boolean enabled;

    public ItemCharmSlowfall() {
        super(64);
    }

    @Override
    public String getContentName() {
        return "charm_wing";
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName(), GuideCategory.ITEMBAUBLES);
        LootTableRegistry.registerLoot(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("WingCharm", "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    @Override
    public void onTick(ItemStack stack, EntityPlayer living) {
        if (!this.canTick(stack)) {
            return;
        }
        if (living.field_70143_R >= 6.0f && !living.func_70644_a(potion)) {
            living.func_70690_d(new PotionEffect(potion, 600, 0));
            super.damageCharm(living, stack);
            UtilSound.playSound(living, living.func_180425_c(), SoundEvents.field_189426_aK, living.func_184176_by());
            UtilParticle.spawnParticle(living.func_130014_f_(), EnumParticleTypes.SUSPENDED, living.func_180425_c());
        }
        if (living.func_70644_a(potion) && living.func_70660_b(potion).func_76459_b() < 1) {
            living.func_184589_d(potion);
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == craftItem.func_77973_b();
    }

    @Override
    public IRecipe addRecipe() {
        return super.addRecipe(craftItem);
    }
}

