/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.command;

import com.lothrazar.cyclicmagic.capability.IPlayerExtendedProperties;
import com.lothrazar.cyclicmagic.command.BaseCommand;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class CommandTodoList
extends BaseCommand
implements ICommand {
    public static final String name = "todo";
    private static final String MODE_ADD = "add";
    private static final String MODE_REMOVE = "delete";
    private static final String MODE_SET = "set";
    private static final String MODE_GET = "get";
    public static boolean PERSIST_DEATH;

    public CommandTodoList(boolean op) {
        super(name, op);
    }

    @Override
    public String func_71518_a(ICommandSender s) {
        return "/" + this.func_71517_b() + " <" + MODE_GET + "|" + MODE_SET + "|" + MODE_ADD + "|" + MODE_REMOVE + "> <text>";
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender icommandsender, String[] args) {
        if (!(icommandsender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)icommandsender;
        String todoCurrent = CommandTodoList.getTodoForPlayer(player);
        if (args == null || args.length == 0 || args[0] == null || args[0].isEmpty()) {
            UtilChat.addChatMessage(player, this.func_71518_a(icommandsender));
            return;
        }
        String message = "";
        if (args[0].equals(MODE_GET)) {
            UtilChat.addChatMessage(player, CommandTodoList.getTodoForPlayer(player));
        } else if (args[0].equals(MODE_REMOVE)) {
            todoCurrent = "";
            args[0] = "";
        } else if (args[0].equals(MODE_ADD)) {
            for (int i = 1; i < args.length; ++i) {
                message = message + " " + args[i];
            }
            todoCurrent = todoCurrent.isEmpty() ? message : todoCurrent + " " + message;
        } else if (args[0].equals(MODE_SET)) {
            for (int i = 1; i < args.length; ++i) {
                message = message + " " + args[i];
            }
            todoCurrent = message;
        }
        this.setTodoForPlayer(player, todoCurrent);
    }

    private void setTodoForPlayer(EntityPlayer player, String todoCurrent) {
        IPlayerExtendedProperties props = CapabilityRegistry.getPlayerProperties(player);
        props.setTODO(todoCurrent);
        if (player instanceof EntityPlayerMP) {
            CapabilityRegistry.syncServerDataToClient((EntityPlayerMP)player);
        }
    }

    public static String getTodoForPlayer(EntityPlayer player) {
        IPlayerExtendedProperties props = CapabilityRegistry.getPlayerProperties(player);
        return props.getTODO();
    }
}

