/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.trash;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.liquid.FluidTankBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityTrash
extends TileEntityBaseMachineFluid
implements ITileRedstoneToggle,
ITickable {
    private static final int INVENTORY = 8;
    private int capacity = 16000;
    private boolean doFluid = true;
    private boolean doItems = true;

    public TileEntityTrash() {
        super(8);
        this.tank = new FluidTankBase(this.capacity);
        this.setSlotsForBoth();
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174890_g() {
        return this.getFieldOrdinals().length;
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        if (this.doItems) {
            for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
                this.func_70304_b(slot);
            }
        }
        if (this.doFluid) {
            this.drain(this.capacity, true);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("doItems", this.doItems);
        compound.func_74757_a("doFluid", this.doFluid);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.doItems = compound.func_74767_n("doItems");
        this.doFluid = compound.func_74767_n("doFluid");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && !this.doFluid) {
            return false;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && !this.doItems) {
            return false;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case FLUID: {
                return this.doFluid ? 1 : 0;
            }
            case ITEM: {
                return this.doItems ? 1 : 0;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case FLUID: {
                this.doFluid = (value %= 2) == 1;
                this.func_70296_d();
                break;
            }
            case ITEM: {
                this.doItems = (value %= 2) == 1;
                this.func_70296_d();
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        this.needsRedstone = (this.needsRedstone + 1) % 2;
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    static enum Fields {
        FLUID,
        ITEM,
        REDSTONE;

    }
}

