/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.melter;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.block.melter.RecipeMelter;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.liquid.FluidTankFixDesync;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileMelter
extends TileEntityBaseMachineFluid
implements ITileRedstoneToggle,
ITickable {
    private static final int HEAT_REFR_EVERY = 20;
    public static final int RECIPE_SIZE = 4;
    public static final int TANK_FULL = 16000;
    public static final int TIMER_FULL = 160;
    private int recipeIsLocked = 0;
    private int heatLevel;
    private int heatRefresh;
    private InventoryCrafting crafting = new InventoryCrafting((Container)new ContainerDummyHydrator(), 2, 2);
    private RecipeMelter currentRecipe;

    public TileMelter() {
        super(4);
        this.tank = new FluidTankFixDesync(16000, this);
        this.timer = 160;
        this.setSlotsForInsert(0, 3);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174890_g() {
        return this.getFieldOrdinals().length;
    }

    public void func_73660_a() {
        this.currentRecipe = null;
        if (this.currentRecipe == null) {
            this.findMatchingRecipe();
            this.updateLockSlots();
        }
        if (!this.isRunning()) {
            return;
        }
        this.refreshHeat();
        if (this.currentRecipe == null) {
            return;
        }
        if (this.heatLevel > 0) {
            this.timer -= this.heatLevel;
            if (this.timer <= 0 && this.tryProcessRecipe()) {
                this.timer = 160;
            }
        }
    }

    private void refreshHeat() {
        --this.heatRefresh;
        if (this.heatRefresh <= 0) {
            this.heatRefresh = 20;
            this.heatLevel = 0;
            for (EnumFacing f : EnumFacing.values()) {
                IBlockState down = this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(f));
                if (down.func_177230_c() == Blocks.field_150353_l) {
                    this.heatLevel += 2;
                }
                if (down.func_177230_c() != Blocks.field_150356_k) continue;
                ++this.heatLevel;
            }
        }
    }

    private void updateLockSlots() {
        if (this.recipeIsLocked == 1) {
            if (this.currentRecipe != null) {
                ArrayList<Integer> slotsImport = new ArrayList<Integer>();
                for (int slot = 0; slot < 4; ++slot) {
                    if (this.func_70301_a(slot).func_190926_b()) continue;
                    slotsImport.add(slot);
                }
                this.setSlotsForInsert(slotsImport);
            }
        } else {
            this.setSlotsForInsert(Arrays.asList(0, 1, 2, 3));
        }
    }

    public boolean tryProcessRecipe() {
        if (this.currentRecipe != null) {
            boolean fluidAllowed;
            int current = this.getCurrentFluidStackAmount();
            int incoming = this.currentRecipe.getFluidSize();
            Fluid holding = this.getFluidContainedOrNull();
            boolean bl = fluidAllowed = holding == null || holding == this.currentRecipe.getFluidResult();
            if (fluidAllowed && current + incoming <= this.getCapacity() && this.currentRecipe.tryPayCost(this, this.recipeIsLocked == 1)) {
                FluidStack fluidStack = new FluidStack(this.currentRecipe.getFluidResult(), incoming);
                this.fill(fluidStack, true);
                this.setCurrentFluid(current + incoming);
                return true;
            }
        }
        return false;
    }

    private void findMatchingRecipe() {
        boolean allAir = true;
        for (int i = 0; i < 4; ++i) {
            allAir = allAir && this.func_70301_a(i).func_190926_b();
            this.crafting.func_70299_a(i, this.func_70301_a(i).func_77946_l());
        }
        if (allAir) {
            return;
        }
        for (RecipeMelter rec : RecipeMelter.recipes) {
            if (!rec.func_77569_a(this.crafting, this.field_145850_b)) continue;
            this.currentRecipe = rec;
        }
    }

    public void sendOutputItem(ItemStack itemstack) {
        for (int i = 4; i < 8; ++i) {
            if (itemstack.func_190926_b() || itemstack.func_77976_d() == 0) continue;
            itemstack = this.tryMergeStackIntoSlot(itemstack, i);
        }
        if (!itemstack.func_190926_b() && itemstack.func_77976_d() != 0) {
            UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.field_174879_c.func_177984_a(), itemstack);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("redstone", this.needsRedstone);
        compound.func_74768_a("rlock", this.recipeIsLocked);
        compound.func_74768_a("heatRefresh", this.heatRefresh);
        compound.func_74768_a("heatLevel", this.heatLevel);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
        this.recipeIsLocked = compound.func_74762_e("rlock");
        this.heatRefresh = compound.func_74762_e("heatRefresh");
        this.heatLevel = compound.func_74762_e("heatLevel");
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
            case RECIPELOCKED: {
                return this.recipeIsLocked;
            }
            case HEATLEVEL: {
                return this.heatLevel;
            }
            case HEATREFRESH: {
                return this.heatRefresh;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case RECIPELOCKED: {
                this.recipeIsLocked = value % 2;
                this.updateLockSlots();
                break;
            }
            case HEATLEVEL: {
                this.heatLevel = value;
                break;
            }
            case HEATREFRESH: {
                this.heatRefresh = value;
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public float getFillRatio() {
        return this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    public static class ContainerDummyHydrator
    extends Container {
        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }

    public static enum Fields {
        REDSTONE,
        TIMER,
        RECIPELOCKED,
        HEATLEVEL,
        HEATREFRESH;

    }
}

