/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.hydrator;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.block.hydrator.ItemBlockHydrator;
import com.lothrazar.cyclicmagic.block.hydrator.RecipeHydrate;
import com.lothrazar.cyclicmagic.block.hydrator.TileEntityHydrator;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class BlockHydrator
extends BlockBaseHasTile
implements IContent,
IHasRecipe {
    public static int FUEL_COST = 0;
    private boolean enabled;

    public BlockHydrator() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f).func_149752_b(5.0f);
        this.setGuiId(23);
        RecipeHydrate.initAllRecipes();
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityHydrator();
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), "rsr", "lgl", "ooo", Character.valueOf('l'), Blocks.field_150435_aG, Character.valueOf('o'), Blocks.field_150405_ch, Character.valueOf('g'), "blockIron", Character.valueOf('s'), Blocks.field_150409_cd, Character.valueOf('r'), Items.field_151131_as);
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityHydrator) {
            float fill = ((TileEntityHydrator)te).getFillRatio();
            return (int)(15.0f * fill);
        }
        return 0;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityHydrator te = (TileEntityHydrator)world.func_175625_s(pos);
        boolean success = false;
        success = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
        if (te != null && !world.field_72995_K) {
            int currentFluid = te.getCurrentFluidStackAmount();
            UtilChat.sendStatusMessage(player, UtilChat.lang("cyclic.fluid.amount") + currentFluid);
        }
        return success || FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null || super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityHydrator te;
        FluidStack fs;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = Item.func_150898_a((Block)this);
        TileEntity ent = world.func_175625_s(pos);
        ItemStack stack = new ItemStack(item);
        if (ent != null && ent instanceof TileEntityHydrator && (fs = (te = (TileEntityHydrator)ent).getCurrentFluidStack()) != null) {
            UtilNBT.setItemStackNBTVal(stack, "Amount", fs.amount);
            String resourceStr = FluidRegistry.getFluidName((Fluid)fs.getFluid());
            UtilNBT.setItemStackNBTVal(stack, "FluidName", resourceStr);
        }
        ret.add(stack);
        return ret;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            NBTTagCompound tags = stack.func_77978_p();
            int fluidAmt = tags.func_74762_e("Amount");
            String resourceStr = tags.func_74779_i("FluidName");
            TileEntityHydrator container = (TileEntityHydrator)worldIn.func_175625_s(pos);
            Fluid fluidObj = FluidRegistry.getFluid((String)resourceStr);
            if (fluidObj != null) {
                container.fill(new FluidStack(fluidObj, fluidAmt), true);
            }
        }
    }

    @Override
    public String getContentName() {
        return "block_hydrator";
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, new ItemBlockHydrator(this), this.getContentName(), GuideCategory.BLOCKMACHINE);
        BlockRegistry.registerTileEntity(TileEntityHydrator.class, this.getContentName() + "_te");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("Hydrator", "cyclicmagic.content", true, " Set false to delete - requires restart");
        FUEL_COST = config.getInt(this.getContentName(), "cyclicmagic.FuelCost", 10, 0, 500000, "Fuel/Energy/RF cost to run machine");
    }
}

