/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.cablepump;

import com.google.common.collect.Maps;
import com.lothrazar.cyclicmagic.block.IFacingBlacklist;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityBasePump
extends TileEntityBaseMachineFluid
implements IFacingBlacklist {
    private Map<EnumFacing, Boolean> mapBlacklist = Maps.newHashMap();

    public TileEntityBasePump(int invoSize) {
        super(invoSize);
        this.needsRedstone = 0;
        for (EnumFacing f : EnumFacing.values()) {
            this.mapBlacklist.put(f, false);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (EnumFacing f : EnumFacing.values()) {
            this.mapBlacklist.put(f, compound.func_74767_n(f.func_176610_l() + "_blocked"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        for (EnumFacing f : EnumFacing.values()) {
            compound.func_74757_a(f.func_176610_l() + "_blocked", this.mapBlacklist.get(f).booleanValue());
        }
        return compound;
    }

    @Override
    public boolean getBlacklist(EnumFacing side) {
        return this.mapBlacklist.get(side);
    }

    @Override
    public void toggleBlacklist(EnumFacing side) {
        this.mapBlacklist.put(side, this.mapBlacklist.get(side) == false);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.mapBlacklist != null && facing != null && this.mapBlacklist.get(facing).booleanValue()) {
            return false;
        }
        return super.hasCapability(capability, facing);
    }
}

