/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.cable;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.lothrazar.cyclicmagic.block.cable.TileEntityCableBase;
import com.lothrazar.cyclicmagic.block.cable.item.TileEntityItemCable;
import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class BlockCableBase
extends BlockBaseHasTile {
    private static final double SML = 0.375;
    private static final double LRG = 0.625;
    public static final float hitLimit = 0.2f;
    protected static final Map<EnumFacing, PropertyEnum<EnumConnectType>> PROPERTIES = Maps.newEnumMap((Map)new ImmutableMap.Builder().put((Object)EnumFacing.DOWN, (Object)PropertyEnum.func_177709_a((String)"down", EnumConnectType.class)).put((Object)EnumFacing.UP, (Object)PropertyEnum.func_177709_a((String)"up", EnumConnectType.class)).put((Object)EnumFacing.NORTH, (Object)PropertyEnum.func_177709_a((String)"north", EnumConnectType.class)).put((Object)EnumFacing.SOUTH, (Object)PropertyEnum.func_177709_a((String)"south", EnumConnectType.class)).put((Object)EnumFacing.WEST, (Object)PropertyEnum.func_177709_a((String)"west", EnumConnectType.class)).put((Object)EnumFacing.EAST, (Object)PropertyEnum.func_177709_a((String)"east", EnumConnectType.class)).build());
    public static final AxisAlignedBB AABB_NONE = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
    public static final Map<EnumFacing, AxisAlignedBB> AABB_SIDES = Maps.newEnumMap((Map)new ImmutableMap.Builder().put((Object)EnumFacing.DOWN, (Object)new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625)).put((Object)EnumFacing.UP, (Object)new AxisAlignedBB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625)).put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.375)).put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.375, 0.375, 0.625, 0.625, 0.625, 1.0)).put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.375, 0.375, 0.375, 0.625, 0.625)).put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.625, 0.375, 0.375, 1.0, 0.625, 0.625)).build());
    private boolean itemTransport = false;
    private boolean fluidTransport = false;
    private boolean powerTransport = false;

    public BlockCableBase() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.func_176223_P());
        this.func_149711_c(0.5f);
        this.func_149752_b(4.5f);
        this.func_149713_g(0);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    public static boolean isWrenchItem(ItemStack held) {
        return held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityCableBase te = (TileEntityCableBase)world.func_175625_s(pos);
        if (te != null) {
            if (BlockCableBase.isWrenchItem(player.func_184586_b(hand))) {
                EnumFacing sideToToggle = null;
                sideToToggle = hitX < 0.2f ? EnumFacing.WEST : (hitX > 0.8f ? EnumFacing.EAST : (hitY < 0.2f ? EnumFacing.DOWN : (hitY > 0.8f ? EnumFacing.UP : (hitZ < 0.2f ? EnumFacing.NORTH : (hitZ > 0.8f ? EnumFacing.SOUTH : side)))));
                if (sideToToggle != null) {
                    te.toggleBlacklist(sideToToggle);
                    boolean theNew = te.getBlacklist(sideToToggle);
                    world.func_175656_a(pos, state.func_177226_a((IProperty)PROPERTIES.get(sideToToggle), (Comparable)((Object)(theNew ? EnumConnectType.BLOCKED : EnumConnectType.NONE))));
                    UtilChat.sendStatusMessage(player, UtilChat.lang("cable.block.toggled." + theNew) + sideToToggle.name().toLowerCase());
                }
                return true;
            }
            if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
                UtilChat.sendStatusMessage(player, te.getLabelTextOrEmpty());
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityItemCable) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityItemCable)tileentity));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos origin) {
        BlockPos pos = new BlockPos((Vec3i)origin);
        TileEntityCableBase cableHere = (TileEntityCableBase)world.func_175625_s(pos);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            PropertyEnum<EnumConnectType> property = PROPERTIES.get(side);
            if (cableHere.getBlacklist(side)) {
                state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.BLOCKED));
                continue;
            }
            pos = origin.func_177972_a(side);
            state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.NONE));
            TileEntity tileTarget = world.func_175625_s(pos);
            TileEntityCableBase tileCable = null;
            if (tileTarget != null && tileTarget instanceof TileEntityCableBase) {
                tileCable = (TileEntityCableBase)tileTarget;
            }
            if (tileCable != null && tileCable.getBlacklist(side.func_176734_d())) continue;
            if (this.powerTransport) {
                if (tileCable != null && tileCable.isEnergyPipe()) {
                    state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.CABLE));
                }
                if (tileTarget != null && tileTarget.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) {
                    state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.CABLE));
                }
            }
            if (this.itemTransport) {
                if (tileCable != null && tileCable.isItemPipe()) {
                    state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.INVENTORY));
                }
                if (tileTarget != null && tileTarget.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) {
                    state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.INVENTORY));
                }
            }
            if (!this.fluidTransport) continue;
            if (tileCable != null && tileCable.isFluidPipe()) {
                state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.CABLE));
            }
            if (tileTarget == null || !tileTarget.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) continue;
            state = state.func_177226_a(property, (Comparable)((Object)EnumConnectType.INVENTORY));
        }
        return super.func_176221_a(state, world, origin);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && super.func_176225_a(state, world, pos, side);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        BlockCableBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_NONE);
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)world, pos);
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (((EnumConnectType)((Object)state.func_177229_b((IProperty)PROPERTIES.get(side)))).isHollow()) continue;
            BlockCableBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SIDES.get(side));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        AxisAlignedBB box = AABB_NONE.func_186670_a(pos);
        state = state.func_185899_b((IBlockAccess)world, pos);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (((EnumConnectType)((Object)state.func_177229_b((IProperty)PROPERTIES.get(side)))).isHollow()) continue;
            box = box.func_111270_a(AABB_SIDES.get(side).func_186670_a(pos));
        }
        return box;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList boxes = Lists.newArrayList((Object[])new AxisAlignedBB[]{AABB_NONE});
        state = state.func_185899_b((IBlockAccess)world, pos);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (((EnumConnectType)((Object)state.func_177229_b((IProperty)PROPERTIES.get(side)))).isHollow()) continue;
            boxes.add(AABB_SIDES.get(side));
        }
        ArrayList<RayTraceResult> results = new ArrayList<RayTraceResult>();
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        Vec3d a = start.func_178786_a(x, y, z);
        Vec3d b = end.func_178786_a(x, y, z);
        for (AxisAlignedBB box : boxes) {
            RayTraceResult result = box.func_72327_a(a, b);
            if (result == null) continue;
            Vec3d vec = result.field_72307_f.func_72441_c(x, y, z);
            results.add(new RayTraceResult(vec, result.field_178784_b, pos));
        }
        RayTraceResult ret = null;
        double sqrDis = 0.0;
        for (RayTraceResult result : results) {
            double newSqrDis = result.field_72307_f.func_72436_e(end);
            if (!(newSqrDis > sqrDis)) continue;
            ret = result;
            sqrDis = newSqrDis;
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        for (PropertyEnum<EnumConnectType> property : PROPERTIES.values()) {
            builder.add(new IProperty[]{property});
        }
        return builder.build();
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void setItemTransport() {
        this.itemTransport = true;
    }

    public void setFluidTransport() {
        this.fluidTransport = true;
    }

    public void setPowerTransport() {
        this.powerTransport = true;
    }

    public static enum EnumConnectType implements IStringSerializable
    {
        NONE,
        CABLE,
        INVENTORY,
        BLOCKED;


        public boolean isHollow() {
            return this == NONE || this == BLOCKED;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

