/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.buildershape;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.buildershape.BlockStructureBuilder;
import com.lothrazar.cyclicmagic.block.buildershape.StructureBuilderType;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.data.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.item.locationgps.ItemLocationGps;
import com.lothrazar.cyclicmagic.util.UtilFakePlayer;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilShape;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityStructureBuilder
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITilePreviewToggle,
ITickable {
    private static final int spotsSkippablePerTrigger = 50;
    private static final String NBT_BUILDTYPE = "build";
    private static final String NBT_SHAPEINDEX = "shapeindex";
    private int buildType;
    private int buildSize = 3;
    private int height;
    private int shapeIndex = 0;
    public static int maxSize;
    public static int maxHeight;
    public static final int SLOT_GPS = 9;
    private WeakReference<FakePlayer> fakePlayer;
    private UUID uuid;

    public TileEntityStructureBuilder() {
        super(10);
        this.initEnergy(new EnergyStore(64000), BlockStructureBuilder.FUEL_COST);
        this.setSlotsForInsert(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8));
        this.needsRedstone = 1;
        this.renderParticles = 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public List<BlockPos> getShape() {
        StructureBuilderType buildType = this.getBuildTypeEnum();
        List<BlockPos> shape = new ArrayList<BlockPos>();
        EnumFacing currFacing = this.getCurrentFacing();
        switch (buildType) {
            case CIRCLE: {
                shape = UtilShape.circleHorizontal(this.getPosTarget(), this.getSize() * 2);
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case FACING: {
                shape = UtilShape.line(this.getPosTarget(), currFacing, this.getSize());
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case SQUARE: {
                shape = UtilShape.squareHorizontalHollow(this.getPosTarget(), this.getSize());
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case SOLID: {
                shape = UtilShape.squareHorizontalFull(this.getTargetFacing(), this.getSize());
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case SPHERE: {
                shape = UtilShape.sphere(this.getPosTarget(), this.getSize());
                break;
            }
            case DOME: {
                shape = UtilShape.sphereDome(this.getPosTarget(), this.getSize());
                break;
            }
            case CUP: {
                shape = UtilShape.sphereCup(this.getPosTarget().func_177981_b(this.getSize()), this.getSize());
                break;
            }
            case DIAGONAL: {
                shape = UtilShape.diagonal(this.getPosTarget(), currFacing, this.getHeight(), this.getSize(), true);
                break;
            }
            case PYRAMID: {
                shape = UtilShape.squarePyramid(this.getPosTarget(), this.getSize(), this.getHeight());
                break;
            }
            case TUNNEL: {
                shape = UtilShape.circleVertical(this.getPosTarget(), this.getSize(), this.getHeight(), currFacing);
            }
        }
        return shape;
    }

    private BlockPos getPosTarget() {
        ItemStack gps = this.func_70301_a(9);
        BlockPosDim target = ItemLocationGps.getPosition(gps);
        BlockPos myTarget = null;
        myTarget = target == null ? this.func_174877_v() : target.toBlockPos();
        return myTarget;
    }

    public BlockPos getTargetFacing() {
        return this.getPosTarget().func_177967_a(this.getCurrentFacing(), this.getSize() + 1);
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 9) {
            return stack.func_77973_b() instanceof ItemLocationGps;
        }
        return true;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case BUILDTYPE: {
                    return this.buildType;
                }
                case SPEED: {
                    return this.speed;
                }
                case SIZE: {
                    return this.buildSize;
                }
                case HEIGHT: {
                    return this.height;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
                case RENDERPARTICLES: {
                    return this.renderParticles;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case BUILDTYPE: {
                    if (value >= StructureBuilderType.values().length) {
                        value = 0;
                    }
                    this.buildType = value;
                    break;
                }
                case SPEED: {
                    this.speed = value;
                    break;
                }
                case SIZE: {
                    this.buildSize = value;
                    break;
                }
                case HEIGHT: {
                    if (value > maxHeight) {
                        value = maxHeight;
                    }
                    this.height = Math.max(1, value);
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                    break;
                }
                case RENDERPARTICLES: {
                    this.renderParticles = value % 2;
                }
            }
        }
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public int getTimer() {
        return this.func_174887_a_(Fields.TIMER.ordinal());
    }

    public int getHeight() {
        return this.func_174887_a_(Fields.HEIGHT.ordinal());
    }

    public void setHeight(int value) {
        this.func_174885_b(Fields.HEIGHT.ordinal(), value);
    }

    public int getBuildType() {
        return this.func_174887_a_(Fields.BUILDTYPE.ordinal());
    }

    public void setBuildType(int value) {
        this.func_174885_b(Fields.BUILDTYPE.ordinal(), value);
    }

    public StructureBuilderType getBuildTypeEnum() {
        int bt = Math.min(this.getBuildType(), StructureBuilderType.values().length - 1);
        return StructureBuilderType.values()[bt];
    }

    public void setSize(int s) {
        if (s <= 0) {
            s = 1;
        }
        if (s >= maxSize) {
            s = maxSize;
        }
        this.func_174885_b(Fields.SIZE.ordinal(), s);
    }

    public int getSize() {
        int s = this.func_174887_a_(Fields.SIZE.ordinal());
        if (s <= 0) {
            s = 1;
        }
        return s;
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.shapeIndex = tagCompound.func_74762_e(NBT_SHAPEINDEX);
        this.buildType = tagCompound.func_74762_e(NBT_BUILDTYPE);
        this.buildSize = tagCompound.func_74762_e("size");
        this.setHeight(tagCompound.func_74762_e("buildHeight"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("buildHeight", this.height);
        tagCompound.func_74768_a(NBT_SHAPEINDEX, this.shapeIndex);
        tagCompound.func_74768_a(NBT_BUILDTYPE, this.getBuildType());
        tagCompound.func_74768_a("size", this.buildSize);
        return super.func_189515_b(tagCompound);
    }

    private void verifyFakePlayer(WorldServer w) {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        if (this.fakePlayer == null) {
            this.fakePlayer = UtilFakePlayer.initFakePlayer(w, this.uuid, this.func_145838_q().func_149739_a());
            if (this.fakePlayer == null) {
                ModCyclic.logger.error("Fake player failed to init ");
            }
        }
    }

    public void func_73660_a() {
        if (!this.isRunning() || this.isInventoryEmpty()) {
            return;
        }
        if (this.field_145850_b instanceof WorldServer) {
            this.verifyFakePlayer((WorldServer)this.field_145850_b);
        }
        this.shiftAllUp(1);
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_190926_b()) {
            return;
        }
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return;
        }
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        BlockPos nextPos = shape.get(this.shapeIndex);
        for (int i = 0; i < 50; ++i) {
            if (this.field_145850_b.func_175623_d(nextPos) && this.fakePlayer != null) {
                Vec3d tarVec;
                ItemStack gps = this.func_70301_a(9);
                BlockPosDim target = ItemLocationGps.getPosition(gps);
                EnumFacing targetSide = target == null ? EnumFacing.UP : target.getSide();
                EnumFacing facingSide = target == null ? EnumFacing.NORTH : target.getSidePlayerFacing();
                Vec3d vec3d = tarVec = target == null ? Vec3d.field_186680_a : target.getHitVec();
                if (!UtilPlaceBlocks.buildStackAsPlayer(this.field_145850_b, (EntityPlayer)this.fakePlayer.get(), nextPos, stack, targetSide, tarVec, facingSide)) break;
                break;
            }
            nextPos = shape.get(this.shapeIndex);
            this.incrementPosition(shape);
        }
    }

    private void incrementPosition(List<BlockPos> shape) {
        if (shape == null || shape.size() == 0) {
            return;
        }
        int c = this.shapeIndex + 1;
        if (c < 0 || c >= shape.size()) {
            c = 0;
        }
        this.shapeIndex = c;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.renderParticles == 1;
    }

    static {
        maxHeight = 10;
    }

    public static enum Fields {
        TIMER,
        BUILDTYPE,
        SPEED,
        SIZE,
        HEIGHT,
        REDSTONE,
        RENDERPARTICLES;

    }
}

