/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.buildershape;

public enum StructureBuilderType {
    FACING,
    SQUARE,
    CIRCLE,
    SOLID,
    SPHERE,
    DIAGONAL,
    DOME,
    CUP,
    PYRAMID,
    TUNNEL;

    public static final StructureBuilderType[] SORTED;

    public static StructureBuilderType getNextType(StructureBuilderType btype) {
        int type = btype.ordinal();
        if (++type > SPHERE.ordinal()) {
            type = FACING.ordinal();
        }
        return StructureBuilderType.values()[type];
    }

    public boolean hasHeight() {
        return this != SPHERE && this != DIAGONAL && this != DOME && this != CUP;
    }

    public String shortcode() {
        switch (this) {
            case CIRCLE: {
                return "Ci";
            }
            case DIAGONAL: {
                return "Di";
            }
            case FACING: {
                return "Fa";
            }
            case SOLID: {
                return "So";
            }
            case SPHERE: {
                return "Sp";
            }
            case SQUARE: {
                return "Sq";
            }
            case DOME: {
                return "Do";
            }
            case CUP: {
                return "Cu";
            }
            case PYRAMID: {
                return "Py";
            }
            case TUNNEL: {
                return "Tu";
            }
        }
        return "";
    }

    static {
        SORTED = new StructureBuilderType[]{FACING, SQUARE, CIRCLE, SOLID, SPHERE, DIAGONAL, DOME, CUP, PYRAMID, TUNNEL};
    }
}

