/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.transport.BCTransportConfig;
import buildcraft.transport.BCTransportPipes;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.BCTransportStatements;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ActionPowerLimit
extends BCStatement
implements IActionInternal {
    public final PipeDefinition pipe;
    public final int limitShift;

    public ActionPowerLimit(PipeDefinition pipe, int limitShift, String ... uniqueTags) {
        super(uniqueTags);
        this.pipe = pipe;
        this.limitShift = limitShift;
    }

    public ActionPowerLimit(String suffix, PipeDefinition pipe, int limitShift) {
        this(pipe, limitShift, "buildcraft:pipe.power_limit." + suffix + "_s" + limitShift);
    }

    protected boolean isRf() {
        return false;
    }

    @Override
    public String getDescription() {
        if (this.isRf()) {
            PipeApi.RedstoneFluxTransferInfo pipeInfo = PipeApi.rfTransferData.get(this.pipe);
            Object max = this.limitShift == 6 ? Integer.valueOf(0) : (pipeInfo == null ? "??[INVALID_PIPE]??" : Integer.valueOf(pipeInfo.transferPerTick >> this.limitShift));
            return LocaleUtil.localize("gate.action.pipe.rf_limit", max);
        }
        PipeApi.PowerTransferInfo pipeInfo = PipeApi.powerTransferData.get(this.pipe);
        Object max = this.limitShift == 6 ? Integer.valueOf(0) : (pipeInfo == null ? "??[INVALID_PIPE]??" : Integer.valueOf((int)((pipeInfo.transferPerTick >> this.limitShift) / MjAPI.MJ)));
        return LocaleUtil.localize("gate.action.pipe.power_limit", max);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        SpriteHolderRegistry.SpriteHolder[] sprites = BCTransportConfig.powerPipeUseOldMjTexture || !this.isRf() ? BCTransportSprites.POWER_LIMIT : BCTransportSprites.POWER_LIMIT_RF;
        return sprites[this.limitShift];
    }

    @Override
    public void actionActivate(IStatementContainer source, IStatementParameter[] parameters) {
    }

    @Override
    public abstract IStatement[] getPossible();

    public static class ActionDiamondRfLimit
    extends ActionPowerLimit {
        public ActionDiamondRfLimit(int limitShift) {
            super("diamond_rf", BCTransportPipes.diamondRf, limitShift);
        }

        @Override
        public IStatement[] getPossible() {
            return BCTransportStatements.ACTION_DIAMOND_RF_LIMIT;
        }

        @Override
        protected boolean isRf() {
            return true;
        }
    }

    public static class ActionIronRfLimit
    extends ActionPowerLimit {
        public ActionIronRfLimit(int limitShift) {
            super("iron_rf", BCTransportPipes.ironRf, limitShift);
        }

        @Override
        public IStatement[] getPossible() {
            return BCTransportStatements.ACTION_IRON_RF_LIMIT;
        }

        @Override
        protected boolean isRf() {
            return true;
        }
    }

    public static class ActionDiamondPowerLimit
    extends ActionPowerLimit {
        public ActionDiamondPowerLimit(int limitShift) {
            super("diamond", BCTransportPipes.diamondPower, limitShift);
        }

        @Override
        public IStatement[] getPossible() {
            return BCTransportStatements.ACTION_DIAMOND_POWER_LIMIT;
        }
    }

    public static class ActionIronPowerLimit
    extends ActionPowerLimit {
        public ActionIronPowerLimit(int limitShift) {
            super("iron", BCTransportPipes.ironPower, limitShift);
        }

        @Override
        public IStatement[] getPossible() {
            return BCTransportStatements.ACTION_IRON_POWER_LIMIT;
        }
    }
}

