/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.BCModules;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.transport.pipe.EnumPipeColourType;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.core.BCCoreConfig;
import buildcraft.lib.config.EnumRestartRequirement;
import buildcraft.lib.misc.ConfigUtil;
import buildcraft.lib.misc.MathUtil;
import buildcraft.transport.BCTransportPipes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BCTransportConfig {
    private static final long MJ_REQ_MILLIBUCKET_MIN = 100L;
    private static final long MJ_REQ_ITEM_MIN = 50000L;
    public static long mjPerMillibucket = 1000L;
    public static long mjPerItem = MjAPI.MJ;
    public static int baseFlowRate = 10;
    public static int basePowerRate = 4;
    public static int baseRfRate = 40;
    public static boolean fluidPipeColourBorder;
    public static boolean disableRfPipe;
    public static boolean powerPipeUseOldMjTexture;
    public static PowerLossMode lossMode;
    private static Property propMjPerMillibucket;
    private static Property propMjPerItem;
    private static Property propBaseFlowRate;
    private static Property propBasePowerRate;
    private static Property propBaseRfRate;
    private static Property propFluidPipeColourBorder;
    private static Property propPowerPipeUseOldMjTexture;
    private static Property propDisableRfPipe;
    private static Property propLossMode;

    public static void preInit() {
        Configuration config = BCCoreConfig.config;
        propMjPerMillibucket = config.get("general", "pipes.mjPerMillibucket", (int)mjPerMillibucket).setMinValue(100);
        EnumRestartRequirement.WORLD.setTo(propMjPerMillibucket);
        propMjPerItem = config.get("general", "pipes.mjPerItem", (int)mjPerItem).setMinValue(50000);
        EnumRestartRequirement.WORLD.setTo(propMjPerItem);
        propBaseFlowRate = config.get("general", "pipes.baseFluidRate", baseFlowRate).setMinValue(1).setMaxValue(40);
        EnumRestartRequirement.WORLD.setTo(propBaseFlowRate);
        propBasePowerRate = config.get("general", "pipes.basePowerRate", basePowerRate).setMinValue(1).setMaxValue(40);
        EnumRestartRequirement.WORLD.setTo(propBasePowerRate);
        propBaseRfRate = config.get("general", "pipes.baseRfRate", baseRfRate).setMinValue(10).setMaxValue(4000);
        EnumRestartRequirement.WORLD.setTo(propBaseRfRate);
        propFluidPipeColourBorder = config.get("display", "pipes.fluidColourIsBorder", true);
        EnumRestartRequirement.WORLD.setTo(propFluidPipeColourBorder);
        propDisableRfPipe = config.get("general", "pipes.disable_rf_pipe", false);
        EnumRestartRequirement.GAME.setTo(propDisableRfPipe);
        disableRfPipe = propDisableRfPipe.getBoolean(false);
        propPowerPipeUseOldMjTexture = config.get("display", "pipes.powerUseOldMjTexture", false);
        EnumRestartRequirement.GAME.setTo(propPowerPipeUseOldMjTexture);
        powerPipeUseOldMjTexture = disableRfPipe && propPowerPipeUseOldMjTexture.getBoolean(false);
        propLossMode = config.get("experimental", "kinesisLossMode", "lossless");
        ConfigUtil.setEnumProperty((Property)propLossMode, (Enum[])PowerLossMode.VALUES);
        EnumRestartRequirement.WORLD.setTo(propLossMode);
        MinecraftForge.EVENT_BUS.register(BCTransportConfig.class);
    }

    public static void reloadConfig(EnumRestartRequirement restarted) {
        if (EnumRestartRequirement.WORLD.hasBeenRestarted(restarted)) {
            mjPerMillibucket = propMjPerMillibucket.getLong();
            if (mjPerMillibucket < 100L) {
                mjPerMillibucket = 100L;
            }
            if ((mjPerItem = propMjPerItem.getLong()) < 50000L) {
                mjPerItem = 50000L;
            }
            baseFlowRate = MathUtil.clamp(propBaseFlowRate.getInt(), 1, 40);
            basePowerRate = MathUtil.clamp(propBasePowerRate.getInt(), 1, 40);
            baseRfRate = MathUtil.clamp(propBaseRfRate.getInt(), 1, 4000);
            fluidPipeColourBorder = propFluidPipeColourBorder.getBoolean();
            PipeApi.flowFluids.fallbackColourType = fluidPipeColourBorder ? EnumPipeColourType.BORDER_INNER : EnumPipeColourType.TRANSLUCENT;
            lossMode = ConfigUtil.parseEnumForConfig(propLossMode, PowerLossMode.DEFAULT);
            BCTransportConfig.fluidTransfer(BCTransportPipes.cobbleFluid, baseFlowRate, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.woodFluid, baseFlowRate, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.stoneFluid, baseFlowRate * 2, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.sandstoneFluid, baseFlowRate * 2, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.clayFluid, baseFlowRate * 4, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.ironFluid, baseFlowRate * 4, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.quartzFluid, baseFlowRate * 4, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.diamondFluid, baseFlowRate * 8, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.diaWoodFluid, baseFlowRate * 8, 10);
            BCTransportConfig.fluidTransfer(BCTransportPipes.goldFluid, baseFlowRate * 8, 2);
            BCTransportConfig.fluidTransfer(BCTransportPipes.voidFluid, baseFlowRate * 8, 10);
            BCTransportConfig.powerTransfer(BCTransportPipes.cobblePower, basePowerRate, 16, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.stonePower, basePowerRate * 2, 32, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.woodPower, basePowerRate * 4, 128, true);
            BCTransportConfig.powerTransfer(BCTransportPipes.sandstonePower, basePowerRate * 4, 32, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.quartzPower, basePowerRate * 8, 32, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.ironPower, basePowerRate * 8, 32, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.goldPower, basePowerRate * 32, 32, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.diamondPower, basePowerRate * 64, 32, false);
            BCTransportConfig.powerTransfer(BCTransportPipes.diaWoodPower, basePowerRate * 64, 32, true);
            if (!disableRfPipe) {
                BCTransportConfig.rfTransfer(BCTransportPipes.cobbleRf, baseRfRate, false);
                BCTransportConfig.rfTransfer(BCTransportPipes.stoneRf, baseRfRate * 2, false);
                BCTransportConfig.rfTransfer(BCTransportPipes.woodRf, baseRfRate * 4, true);
                BCTransportConfig.rfTransfer(BCTransportPipes.sandstoneRf, baseRfRate * 4, false);
                BCTransportConfig.rfTransfer(BCTransportPipes.quartzRf, baseRfRate * 8, false);
                BCTransportConfig.rfTransfer(BCTransportPipes.ironRf, baseRfRate * 8, false);
                BCTransportConfig.rfTransfer(BCTransportPipes.goldRf, baseRfRate * 32, false);
                BCTransportConfig.rfTransfer(BCTransportPipes.diamondRf, baseRfRate * 64, false);
                BCTransportConfig.rfTransfer(BCTransportPipes.diaWoodRf, baseRfRate * 64, true);
            }
        }
    }

    private static void fluidTransfer(PipeDefinition def, int rate, int delay) {
        PipeApi.fluidTransferData.put(def, new PipeApi.FluidTransferInfo(rate, delay));
    }

    private static void powerTransfer(PipeDefinition def, int transferMultiplier, int resistanceDivisor, boolean recv) {
        long transfer = MjAPI.MJ * (long)transferMultiplier;
        long resistance = MjAPI.MJ / (long)resistanceDivisor;
        PipeApi.powerTransferData.put(def, PipeApi.PowerTransferInfo.createFromResistance(transfer, resistance, recv));
    }

    private static void rfTransfer(PipeDefinition def, int maxTransfer, boolean recv) {
        PipeApi.rfTransferData.put(def, new PipeApi.RedstoneFluxTransferInfo(maxTransfer, recv));
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent cce) {
        if (BCModules.isBcMod(cce.getModID())) {
            EnumRestartRequirement req = EnumRestartRequirement.NONE;
            if (Loader.instance().isInState(LoaderState.AVAILABLE)) {
                req = EnumRestartRequirement.WORLD;
            }
            BCTransportConfig.reloadConfig(req);
        }
    }

    static {
        lossMode = PowerLossMode.DEFAULT;
    }

    public static enum PowerLossMode {
        LOSSLESS,
        PERCENTAGE,
        ABSOLUTE;

        public static final PowerLossMode DEFAULT;
        public static final PowerLossMode[] VALUES;

        static {
            DEFAULT = LOSSLESS;
            VALUES = PowerLossMode.values();
        }
    }
}

