/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.script;

import buildcraft.lib.script.SourceFile;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public interface IScriptFileLog {
    public static final int END_OF_LINE = Integer.MAX_VALUE;

    public void error(int var1, int var2, int var3, String var4);

    default public void error(int line, String message) {
        this.error(line, 0, Integer.MAX_VALUE, message);
    }

    public void populateFile(@Nullable SourceFile var1, List<String> var2);

    public void errorMissingArgument(int var1, int var2, String var3);

    public void infoSkippingIfBlock(int var1);

    public void infoEndSkipping(int var1);

    public void infoConditionalResult(int var1, int var2, int var3, boolean var4);

    public void errorFunctionUnknown(int var1, int var2, int var3, Collection<String> var4);

    default public void errorStdMissingName(int line) {
        this.error(line, "Missing name: ");
    }

    public void errorStdInvalidJson(int var1, JsonSyntaxException var2);

    public void errorStdUnknownFile(int var1, String var2);

    default public void errorImportMissingFile(int line) {
        this.error(line, "Cannot find the file ");
    }

    public void errorImportNotFound(int var1, String var2);

    public void errorImportMissingStarter(int var1, String var2);

    public void errorImportRecursiveReplace(int var1, String var2);

    public void errorAliasInvalidArgCount(int var1, int var2, int var3, @Nullable Integer var4);

    default public void errorAliasMissingName(int tokenStart) {
        this.errorMissingArgument(tokenStart, 0, "The custom name for the function");
    }

    default public void errorAliasMissingArgCount(int tokenStart) {
        this.errorMissingArgument(tokenStart, 1, "The number of arguments for the function");
    }

    default public void errorAliasMissingReplacement(int line) {
        this.errorMissingArgument(line, 2, "The replacement for the alias. This can include ${1} and ${2} etc for the aliased arguments.");
    }

    public void replace(int var1, int var2, @Nullable SourceFile var3, int var4, List<String> var5);
}

