/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.help;

import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.elem.GuiElementContainerHelp;
import buildcraft.lib.gui.elem.GuiElementText;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StringUtilBC;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElementHelpInfo {
    public final String title;
    public final int colour;
    public final String[] localeKeys;
    public final boolean isPreTranslated;

    public ElementHelpInfo(String title, int colour, String ... localeKeys) {
        this.title = title;
        this.colour = colour;
        this.localeKeys = localeKeys;
        this.isPreTranslated = false;
    }

    public ElementHelpInfo(String title, int colour, boolean isPreTranslated, String ... localeKeys) {
        this.title = title;
        this.colour = colour;
        this.localeKeys = localeKeys;
        this.isPreTranslated = isPreTranslated;
    }

    public static ElementHelpInfo preTranslated(String title, int colour, String ... lines) {
        return new ElementHelpInfo(title, colour, true, lines);
    }

    @SideOnly(value=Side.CLIENT)
    public final HelpPosition target(IGuiArea target) {
        return new HelpPosition(this, target);
    }

    @SideOnly(value=Side.CLIENT)
    public void addGuiElements(GuiElementContainerHelp container) {
        BuildCraftGui gui = container.gui;
        int y = 20;
        for (int i = 0; i < this.localeKeys.length; ++i) {
            String key = this.localeKeys[i];
            if (key == null) {
                y += Minecraft.func_71410_x().field_71466_p.field_78288_b + 5;
                continue;
            }
            String localized = this.isPreTranslated ? key : LocaleUtil.localize(key);
            List<String> lines = StringUtilBC.splitIntoLines(localized);
            for (String line : lines) {
                GuiElementText elemText = new GuiElementText(gui, (IGuiPosition)container.offset(0.0, (double)y), line, 0);
                container.add(elemText);
                y = (int)((double)y + (elemText.getHeight() + 5.0));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final class HelpPosition {
        public final ElementHelpInfo info;
        public final IGuiArea target;

        private HelpPosition(ElementHelpInfo info, IGuiArea target) {
            this.info = info;
            this.target = target;
        }
    }
}

