/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.config;

import buildcraft.api.core.BCLog;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.gui.config.GuiConfigManager;
import buildcraft.lib.gui.config.GuiProperty;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public class GuiPropertyBoolean
extends GuiProperty
implements IVariableNode.IVariableNodeBoolean {
    private boolean value;

    public GuiPropertyBoolean(String name) {
        super(name);
    }

    @Override
    public void set(boolean value) {
        this.value = value;
        GuiConfigManager.markDirty();
    }

    @Override
    public boolean evaluate() {
        return this.value;
    }

    @Override
    public JsonElement writeToJson() {
        return new JsonPrimitive(Boolean.valueOf(this.value));
    }

    @Override
    public void readFromJson(JsonElement json) {
        if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isBoolean()) {
            BCLog.logger.warn("[lib.gui.config] Tried to read " + json + " as a boolean, but it wasn't!");
        } else {
            this.value = json.getAsBoolean();
        }
    }
}

