/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import java.util.Objects;

public class NodeFuncObjectBooleanToBoolean<A>
extends NodeFuncBase
implements INodeFunc.INodeFuncBoolean {
    public final IFuncObjectBooleanToBoolean<A> function;
    private final StringFunctionTri stringFunction;
    private final Class<A> argTypeA;

    public NodeFuncObjectBooleanToBoolean(String name, Class<A> argTypeA, IFuncObjectBooleanToBoolean<A> function) {
        this(argTypeA, function, (String a, String b) -> "[ " + NodeTypes.getName(argTypeA) + ", boolean -> boolean ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncObjectBooleanToBoolean(Class<A> argTypeA, IFuncObjectBooleanToBoolean<A> function, StringFunctionTri stringFunction) {
        this.argTypeA = argTypeA;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public NodeFuncObjectBooleanToBoolean<A> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeBoolean getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeBoolean b = stack.popBoolean();
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return this.create(a, b);
    }

    public FuncObjectBooleanToBoolean create(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeBoolean argB) {
        return new FuncObjectBooleanToBoolean(argA, argB);
    }

    @FunctionalInterface
    public static interface IFuncObjectBooleanToBoolean<A> {
        public boolean apply(A var1, boolean var2);
    }

    public class FuncObjectBooleanToBoolean
    implements IExpressionNode.INodeBoolean,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeObject<A> argA;
        public final IExpressionNode.INodeBoolean argB;

        public FuncObjectBooleanToBoolean(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeBoolean argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public boolean evaluate() {
            return NodeFuncObjectBooleanToBoolean.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeBoolean inline() {
            if (!NodeFuncObjectBooleanToBoolean.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncObjectBooleanToBoolean(a, (IExpressionNode.INodeBoolean)b), (a, b) -> new FuncObjectBooleanToBoolean(a, (IExpressionNode.INodeBoolean)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncObjectBooleanToBoolean(a, (IExpressionNode.INodeBoolean)b), (a, b) -> NodeConstantBoolean.of(NodeFuncObjectBooleanToBoolean.this.function.apply(a.evaluate(), b.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncObjectBooleanToBoolean.this.canInline) {
                if (NodeFuncObjectBooleanToBoolean.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncObjectBooleanToBoolean.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB);
        }

        public String toString() {
            return NodeFuncObjectBooleanToBoolean.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncObjectBooleanToBoolean.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncObjectBooleanToBoolean other = (FuncObjectBooleanToBoolean)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB);
        }
    }
}

