/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.cast;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.NodeStack;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.cast.NodeCastToString;
import java.util.Collections;

public class NodeCasting {
    public static IExpressionNode.INodeObject<String> castToString(IExpressionNode node) {
        if (node instanceof IExpressionNode.INodeObject && ((IExpressionNode.INodeObject)node).getType() == String.class) {
            return (IExpressionNode.INodeObject)node;
        }
        return new NodeCastToString(node);
    }

    public static INodeFunc.INodeFuncObject<String> castToString(final INodeFunc func) {
        if (func instanceof INodeFunc.INodeFuncObject && ((INodeFunc.INodeFuncObject)func).getType() == String.class) {
            return (INodeFunc.INodeFuncObject)func;
        }
        return new INodeFunc.INodeFuncObject<String>(){

            @Override
            public Class<String> getType() {
                return String.class;
            }

            @Override
            public IExpressionNode.INodeObject<String> getNode(INodeStack stack) throws InvalidExpressionException {
                return new NodeCastToString(func.getNode(stack));
            }
        };
    }

    public static IExpressionNode.INodeDouble castToDouble(IExpressionNode node) throws InvalidExpressionException {
        if (node instanceof IExpressionNode.INodeDouble) {
            return (IExpressionNode.INodeDouble)node;
        }
        Class<?> type = NodeTypes.getType(node);
        FunctionContext ctx = NodeTypes.getContext(type);
        if (ctx == null) {
            throw new InvalidExpressionException("Cannot cast " + node + " to a double!");
        }
        INodeFunc func = ctx.getFunction("(double)", Collections.singletonList(type));
        if (func == null || NodeTypes.getType(func) != Double.TYPE) {
            throw new InvalidExpressionException("Cannot cast " + node + " to a double!");
        }
        return (IExpressionNode.INodeDouble)func.getNode(new NodeStack(node));
    }

    public static INodeFunc.INodeFuncDouble castToDouble(INodeFunc func) throws InvalidExpressionException {
        if (func instanceof INodeFunc.INodeFuncDouble) {
            return (INodeFunc.INodeFuncDouble)func;
        }
        Class<?> type = NodeTypes.getType(func);
        FunctionContext ctx = NodeTypes.getContext(type);
        if (ctx == null) {
            throw new InvalidExpressionException("Cannot cast " + func + " to a double!");
        }
        INodeFunc caster = ctx.getFunction("(double)", Collections.singletonList(type));
        if (caster == null || NodeTypes.getType(caster) != Double.TYPE) {
            throw new InvalidExpressionException("Cannot cast " + func + " to a double!");
        }
        return stack -> (IExpressionNode.INodeDouble)caster.getNode(new NodeStack(func.getNode(stack)));
    }

    public static IExpressionNode castToType(IExpressionNode node, Class<?> to) throws InvalidExpressionException {
        Class<?> from = NodeTypes.getType(node);
        if (from == to) {
            return node;
        }
        FunctionContext castingContext = new FunctionContext(NodeTypes.getContext(from), NodeTypes.getContext(to));
        INodeFunc caster = castingContext.getFunction("(" + NodeTypes.getName(to) + ")", Collections.singletonList(from));
        if (caster == null) {
            if (to == String.class) {
                return new NodeCastToString(node);
            }
            throw new InvalidExpressionException("Cannot cast from " + NodeTypes.getName(from) + " to " + NodeTypes.getName(to));
        }
        NodeStack stack = new NodeStack(node);
        stack.setRecorder(Collections.singletonList(from), caster);
        IExpressionNode casted = caster.getNode(stack);
        stack.checkAndRemoveRecorder();
        Class<?> actual = NodeTypes.getType(casted);
        if (actual != to) {
            throw new IllegalStateException("The caster " + caster + " didn't produce the correct result! (Expected " + to + ", but got " + actual + ")");
        }
        return casted;
    }

    public static <T> IExpressionNode.INodeObject<T> castToObject(IExpressionNode node, Class<T> clazz) throws InvalidExpressionException {
        return (IExpressionNode.INodeObject)NodeCasting.castToType(node, clazz);
    }

    public static <T> INodeFunc.INodeFuncObject<T> castToObject(final INodeFunc func, final Class<T> to) throws InvalidExpressionException {
        Class<?> from = NodeTypes.getType(func);
        if (from == to) {
            return (INodeFunc.INodeFuncObject)func;
        }
        FunctionContext castingContext = new FunctionContext(NodeTypes.getContext(from), NodeTypes.getContext(to));
        final INodeFunc caster = castingContext.getFunction("(" + NodeTypes.getName(to) + ")", Collections.singletonList(from));
        if (caster == null) {
            if (to == String.class) {
                return NodeCasting.castToString(func);
            }
            throw new InvalidExpressionException("Cannot cast from " + NodeTypes.getName(from) + " to " + NodeTypes.getName(to));
        }
        return new INodeFunc.INodeFuncObject<T>(){

            @Override
            public IExpressionNode.INodeObject<T> getNode(INodeStack stack) throws InvalidExpressionException {
                return (IExpressionNode.INodeObject)caster.getNode(new NodeStack(func.getNode(stack)));
            }

            @Override
            public Class<T> getType() {
                return to;
            }
        };
    }
}

