/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression;

import buildcraft.lib.expression.Tokenizer;
import java.util.ArrayList;
import java.util.List;

public class TokenizerDefaults {
    public static final Tokenizer.ITokenizerGobbler GOBBLER_QUOTE = ctx -> {
        int length = 1;
        char type = ctx.getCharAt(0);
        if (type != '\'' && type != '\"') {
            return Tokenizer.ResultSpecific.IGNORE;
        }
        while (true) {
            char c;
            if ((c = ctx.getCharAt(length)) == '\\') {
                ++length;
            } else {
                if (c == type) {
                    return new Tokenizer.ResultConsume(length + 1);
                }
                if (c == '\n') {
                    return new Tokenizer.ResultInvalid(length + 1);
                }
            }
            ++length;
        }
    };
    private static final String[] MATH_OPS_2_CHAR = new String[]{"||", "&&", "<=", ">=", "==", "!=", "<<", ">>"};
    public static final Tokenizer.ITokenizerGobbler GOBBLER_MATH_OPERATOR = ctx -> {
        String possible = ctx.get(2);
        for (String s : MATH_OPS_2_CHAR) {
            if (!s.equals(possible)) continue;
            return Tokenizer.ResultConsume.TWO;
        }
        return Tokenizer.ResultSpecific.IGNORE;
    };
    public static final Tokenizer.ITokenizerGobbler GOBBLER_HEXADECIMAL = ctx -> {
        if ("0x".equals(ctx.get(2))) {
            char c;
            int size = 2;
            while ('_' == (c = ctx.getCharAt(size)) || c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                ++size;
            }
            if (size > 2) {
                return new Tokenizer.ResultConsume(size);
            }
            return Tokenizer.ResultSpecific.IGNORE;
        }
        return Tokenizer.ResultSpecific.IGNORE;
    };
    public static final Tokenizer.ITokenizerGobbler GOBBLER_NUMBER = ctx -> {
        boolean digitsAfterDot;
        int i = 0;
        int dot = -1;
        while (true) {
            char c;
            if ((c = ctx.getCharAt(i)) == '.') {
                if (dot >= 0) break;
                dot = i;
            } else if (!Character.isDigit(c)) break;
            ++i;
        }
        if (i == 0) {
            return Tokenizer.ResultSpecific.IGNORE;
        }
        boolean digitsBeforeDot = dot > 0;
        boolean bl = digitsAfterDot = i > dot + 1;
        if (digitsBeforeDot) {
            if (digitsAfterDot) {
                return new Tokenizer.ResultConsume(i);
            }
            return new Tokenizer.ResultConsume(i - 1);
        }
        if (digitsAfterDot) {
            return new Tokenizer.ResultConsume(i);
        }
        return Tokenizer.ResultSpecific.IGNORE;
    };
    public static final Tokenizer.ITokenizerGobbler GOBBLER_WORD = ctx -> {
        int i = 0;
        while (true) {
            char c = ctx.getCharAt(i);
            if (i == 0 ? c != '.' && !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c)) break;
            ++i;
        }
        return i == 0 ? Tokenizer.ResultSpecific.IGNORE : new Tokenizer.ResultConsume(i);
    };
    public static final Tokenizer.ITokenizerGobbler GOBBLER_NON_WHITESPACE = ctx -> {
        char c = ctx.getCharAt(0);
        if (c == '\n') {
            return Tokenizer.ResultSpecific.IGNORE;
        }
        if (Character.isWhitespace(c)) {
            return Tokenizer.ResultSpecific.IGNORE;
        }
        return Tokenizer.ResultConsume.ONE;
    };
    public static final Tokenizer.ITokenizerGobbler GOBBLER_DISCARD = ctx -> Tokenizer.ResultDiscard.SINGLE;

    public static List<Tokenizer.ITokenizerGobbler> createParts() {
        ArrayList<Tokenizer.ITokenizerGobbler> list = new ArrayList<Tokenizer.ITokenizerGobbler>();
        list.add(GOBBLER_QUOTE);
        list.add(GOBBLER_MATH_OPERATOR);
        list.add(GOBBLER_HEXADECIMAL);
        list.add(GOBBLER_NUMBER);
        list.add(GOBBLER_WORD);
        list.add(GOBBLER_NON_WHITESPACE);
        list.add(GOBBLER_DISCARD);
        return list;
    }

    public static Tokenizer createTokenizer() {
        return new Tokenizer(TokenizerDefaults.createParts());
    }
}

