/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.ref;

import buildcraft.lib.client.guide.entry.PageValue;
import buildcraft.lib.client.guide.ref.GuideGroupManager;
import buildcraft.lib.misc.LocaleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public final class GuideGroupSet {
    public final ResourceLocation group;
    public final List<PageValue<?>> sources;
    public final List<PageValue<?>> entries;

    public GuideGroupSet(ResourceLocation group) {
        this.group = group;
        this.sources = new ArrayList();
        this.entries = new ArrayList();
    }

    public String getTitle(GroupDirection dir) {
        String post = this.group.func_110624_b() + "." + this.group.func_110623_a();
        return LocaleUtil.localize(dir.localePrefix + post);
    }

    public List<PageValue<?>> getValues(GroupDirection direction) {
        return direction == GroupDirection.SRC_TO_ENTRY ? this.entries : this.sources;
    }

    public GuideGroupSet addSingle(Object value) {
        PageValue<?> entry = GuideGroupManager.toPageValue(value);
        if (entry != null) {
            this.entries.add(entry);
        }
        return this;
    }

    public GuideGroupSet addArray(Object ... values) {
        for (Object value : values) {
            this.addSingle(value);
        }
        return this;
    }

    public GuideGroupSet addCollection(Collection<? extends Object> values) {
        for (Object object : values) {
            this.addSingle(object);
        }
        return this;
    }

    public GuideGroupSet addKey(Object value) {
        PageValue<?> entry = GuideGroupManager.toPageValue(value);
        if (entry != null) {
            this.sources.add(entry);
        }
        return this;
    }

    public GuideGroupSet addKeyArray(Object ... values) {
        for (Object value : values) {
            this.addKey(value);
        }
        return this;
    }

    public GuideGroupSet addKeyCollection(Collection<? extends Object> values) {
        for (Object object : values) {
            this.addKey(object);
        }
        return this;
    }

    public static enum GroupDirection {
        SRC_TO_ENTRY("to."),
        ENTRY_TO_SRC("from.");

        public final String localePrefix;

        private GroupDirection(String localePrefix) {
            this.localePrefix = "buildcraft.guide.group." + localePrefix;
        }
    }
}

