/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.enums.EnumPowerStage;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.transport.pipe.IItemPipe;
import buildcraft.energy.BCEnergyGuis;
import buildcraft.energy.tile.TileEngineRF;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.block.VanillaRotationHandlers;
import buildcraft.lib.engine.IEngineLikeForLedger;
import buildcraft.lib.misc.EntityUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.collect.OrderedEnumMap;
import buildcraft.lib.misc.data.ModelVariableData;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.lib.tile.item.StackInsertionFunction;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDynamoMJ
extends TileBC_Neptune
implements ITickable,
IEngineLikeForLedger {
    public static final int MAX_RF = 10000;
    public static final long MAX_MJ = 1000L * MjAPI.MJ;
    public static final double HEAT_RATE = 0.06;
    public static final double COOLDOWN_RATE = 0.01;
    public static final double MIN_HEAT = 20.0;
    public static final double IDEAL_HEAT = 100.0;
    public static final double MAX_HEAT = 250.0;
    private final MjBattery mjBattery;
    private final MjBatteryReceiver mjConnector;
    private final MjCapabilityHelper mjCaps;
    private final Rf rf = new Rf();
    int currentRF;
    public final ItemHandlerSimple invUpgrades;
    protected double heat = 20.0;
    private float progress;
    private float lastProgress;
    private int progressPart = 0;
    protected EnumPowerStage powerStage = EnumPowerStage.BLUE;
    protected EnumFacing currentDirection = EnumFacing.UP;
    public long currentOutput;
    public boolean isRedstonePowered = false;
    protected boolean isPumping = false;
    public final ModelVariableData clientModelData = new ModelVariableData();

    public TileDynamoMJ() {
        this.mjBattery = new MjBattery(MAX_MJ);
        this.mjConnector = new MjBatteryReceiver(this.mjBattery);
        this.mjCaps = new MjCapabilityHelper(this.mjConnector);
        this.invUpgrades = this.itemManager.addInvHandler("upgrades", 4, this::isValidUpgrade, StackInsertionFunction.getInsertionFunction(1), ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("currentDirection", NBTUtilBC.writeEnum(this.currentDirection));
        nbt.func_74757_a("isRedstonePowered", this.isRedstonePowered);
        nbt.func_74780_a("heat", this.heat);
        nbt.func_74776_a("progress", this.progress);
        nbt.func_74768_a("progressPart", this.progressPart);
        nbt.func_74768_a("currentRF", this.currentRF);
        nbt.func_74782_a("mj", (NBTBase)this.mjBattery.serializeNBT());
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentDirection = NBTUtilBC.readEnum(nbt.func_74781_a("currentDirection"), EnumFacing.class);
        if (this.currentDirection == null) {
            this.currentDirection = EnumFacing.UP;
        }
        this.isRedstonePowered = nbt.func_74767_n("isRedstonePowered");
        this.heat = nbt.func_74769_h("heat");
        this.progress = nbt.func_74760_g("progress");
        this.progressPart = nbt.func_74762_e("progressPart");
        this.currentRF = nbt.func_74762_e("currentRF");
        this.mjBattery.deserializeNBT(nbt.func_74775_l("mj"));
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.isPumping = buffer.readBoolean();
                this.currentDirection = buffer.func_179257_a(EnumFacing.class);
                this.powerStage = buffer.func_179257_a(EnumPowerStage.class);
                this.progress = buffer.readFloat();
            } else if (id == NET_GUI_DATA || id == NET_GUI_TICK) {
                this.heat = buffer.readFloat();
                this.currentOutput = buffer.readLong();
                this.currentRF = buffer.readInt();
                this.mjBattery.readFromBuffer((ByteBuf)buffer);
            }
        }
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                buffer.writeBoolean(this.isPumping);
                buffer.writeEnumValue((Enum<?>)this.currentDirection);
                buffer.writeEnumValue(this.powerStage);
                buffer.writeFloat(this.progress);
            } else if (id == NET_GUI_DATA || id == NET_GUI_TICK) {
                buffer.writeFloat((float)this.heat);
                buffer.writeLong(this.currentOutput);
                buffer.writeInt(this.currentRF);
                this.mjBattery.writeToBuffer((ByteBuf)buffer);
            }
        }
    }

    public EnumActionResult attemptRotation() {
        OrderedEnumMap<EnumFacing> possible = VanillaRotationHandlers.ROTATE_FACING;
        EnumFacing current = this.currentDirection;
        for (int i = 0; i < 6; ++i) {
            if (!this.isFacingReceiver(current = possible.next(current))) continue;
            if (this.currentDirection != current) {
                this.currentDirection = current;
                this.sendNetworkUpdate(NET_RENDER_DATA);
                this.redrawBlock();
                this.field_145850_b.func_175722_b(this.func_174877_v(), this.func_145838_q(), true);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    private boolean isFacingReceiver(EnumFacing dir) {
        return this.getReceiverToPower(dir) != null;
    }

    protected final boolean canChain() {
        return this.getMaxChainLength() > 0;
    }

    protected int getMaxChainLength() {
        return 3;
    }

    public void rotateIfInvalid() {
        if (this.currentDirection != null && this.isFacingReceiver(this.currentDirection)) {
            return;
        }
        this.attemptRotation();
        if (this.currentDirection == null) {
            this.currentDirection = EnumFacing.UP;
        }
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        super.onPlacedBy(placer, stack);
        this.currentDirection = null;
        this.rotateIfInvalid();
    }

    protected Biome getBiome() {
        return this.field_145850_b.func_180494_b(this.func_174877_v());
    }

    protected float getBiomeHeat() {
        Biome biome = this.getBiome();
        float temp = biome.func_180626_a(this.func_174877_v());
        return Math.max(0.0f, Math.min(30.0f, temp * 15.0f));
    }

    public double getPowerLevel() {
        return (double)this.currentRF / 10000.0;
    }

    protected EnumPowerStage computePowerStage() {
        double heatLevel = this.getHeatLevel();
        if (heatLevel < 0.25) {
            return EnumPowerStage.BLUE;
        }
        if (heatLevel < 0.5) {
            return EnumPowerStage.GREEN;
        }
        if (heatLevel < 0.75) {
            return EnumPowerStage.YELLOW;
        }
        if (heatLevel < (double)0.85f) {
            return EnumPowerStage.RED;
        }
        return EnumPowerStage.OVERHEAT;
    }

    @Override
    public final EnumPowerStage getPowerStage() {
        EnumPowerStage newStage;
        if (!this.field_145850_b.field_72995_K && this.powerStage != (newStage = this.computePowerStage())) {
            this.powerStage = newStage;
            this.sendNetworkUpdate(NET_RENDER_DATA);
        }
        return this.powerStage;
    }

    public double getHeatLevel() {
        return (this.heat - 20.0) / 230.0;
    }

    public double getIdealHeatLevel() {
        return this.heat / 100.0;
    }

    @Override
    public double getHeat() {
        return this.heat;
    }

    public double getPistonSpeed() {
        switch (this.getPowerStage()) {
            case BLUE: {
                return 0.04;
            }
            case GREEN: {
                return 0.05;
            }
            case YELLOW: {
                return 0.06;
            }
            case RED: {
                return 0.07;
            }
        }
        return 0.0;
    }

    @Override
    public void onNeighbourBlockChanged(Block block, BlockPos nehighbour) {
        super.onNeighbourBlockChanged(block, nehighbour);
        this.isRedstonePowered = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
    }

    public void func_73660_a() {
        boolean overheat;
        this.deltaManager.tick();
        if (this.cannotUpdate()) {
            return;
        }
        boolean bl = overheat = this.getPowerStage() == EnumPowerStage.OVERHEAT;
        if (this.field_145850_b.field_72995_K) {
            this.lastProgress = this.progress;
            if (this.isPumping) {
                this.progress = (float)((double)this.progress + this.getPistonSpeed());
                if (this.progress >= 1.0f) {
                    this.progress = 0.0f;
                }
            } else if (this.progress > 0.0f) {
                this.progress -= 0.01f;
            }
            this.clientModelData.tick();
            return;
        }
        if (!this.isRedstonePowered) {
            if (this.currentRF > 0) {
                --this.currentRF;
            }
            if (this.currentRF < 0) {
                this.currentRF = 0;
            }
        }
        this.updateHeatLevel();
        this.getPowerStage();
        IEnergyStorage receiver = this.getReceiverToPower(this.currentDirection);
        if (this.progressPart != 0) {
            this.progress = (float)((double)this.progress + this.getPistonSpeed());
            if ((double)this.progress > 0.5 && this.progressPart == 1) {
                this.progressPart = 2;
            } else if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                this.progressPart = 0;
            }
        } else if (this.isRedstonePowered && this.isActive()) {
            if (this.getPowerToExtract(false) > 0) {
                this.progressPart = 1;
                this.setPumping(true);
            } else {
                this.setPumping(false);
            }
        } else {
            this.setPumping(false);
        }
        if (this.isRedstonePowered && this.isActive()) {
            this.sendPower(receiver);
        } else {
            this.currentOutput = 0L;
        }
        if (!overheat) {
            this.burn();
        }
        this.markChunkDirty();
    }

    private int getPowerToExtract(boolean doExtract) {
        IEnergyStorage receiver = this.getReceiverToPower(this.currentDirection);
        if (receiver == null) {
            return 0;
        }
        return this.extractPower(0, receiver.getMaxEnergyStored() - receiver.getEnergyStored(), doExtract);
    }

    private void sendPower(IEnergyStorage receiver) {
        int extracted;
        if (receiver != null && (extracted = this.getPowerToExtract(false)) > 0) {
            int received = receiver.receiveEnergy(extracted, false);
            this.extractPower(received, received, true);
        }
    }

    public boolean isActive() {
        return true;
    }

    protected final void setPumping(boolean isActive) {
        if (this.isPumping == isActive) {
            return;
        }
        this.isPumping = isActive;
        this.sendNetworkUpdate(NET_RENDER_DATA);
    }

    public void addPower(int rf) {
        this.currentRF += rf;
        if (this.getPowerStage() == EnumPowerStage.OVERHEAT) {
            // empty if block
        }
        if (this.currentRF > 10000) {
            this.currentRF = 10000;
        }
    }

    public int extractPower(int min, int max, boolean doExtract) {
        int extracted;
        if (this.currentRF < min) {
            return 0;
        }
        int actualMax = max > this.maxPowerExtracted() ? this.maxPowerExtracted() : max;
        if (actualMax < min) {
            return 0;
        }
        if (this.currentRF >= actualMax) {
            extracted = actualMax;
            if (doExtract) {
                this.currentRF -= actualMax;
            }
        } else {
            extracted = this.currentRF;
            if (doExtract) {
                this.currentRF = 0;
            }
        }
        return extracted;
    }

    public final boolean isPoweredTile(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return false;
        }
        if (tile.getClass() == this.getClass()) {
            TileDynamoMJ other = (TileDynamoMJ)tile;
            return other.currentDirection == this.currentDirection;
        }
        return this.getReceiverToPower(tile, side) != null;
    }

    @Deprecated
    public IEnergyStorage getReceiverToPower(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        IEnergyStorage rec = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
        if (rec != null && rec.canReceive()) {
            return rec;
        }
        return null;
    }

    public IEnergyStorage getReceiverToPower(EnumFacing side) {
        TileDynamoMJ engine = this;
        TileEntity next = null;
        for (int len = 0; len <= this.getMaxChainLength(); ++len) {
            next = engine.getNeighbourTile(side);
            if (next == null) {
                return null;
            }
            if (next.getClass() == this.getClass() && side != ((TileDynamoMJ)next).currentDirection) {
                return null;
            }
            if (!(next instanceof TileDynamoMJ)) break;
            if (next.getClass() != this.getClass()) {
                return null;
            }
            engine = (TileDynamoMJ)next;
        }
        if (next == null || next instanceof TileDynamoMJ) {
            return null;
        }
        IEnergyStorage recv = (IEnergyStorage)next.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
        if (recv != null && recv.canReceive()) {
            return recv;
        }
        return null;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (facing == this.currentDirection) {
            if (CapabilityEnergy.ENERGY == capability) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.rf);
            }
            return super.getCapability(capability, facing);
        }
        T cap = this.mjCaps.getCapability(capability, facing);
        return cap != null ? cap : super.getCapability(capability, facing);
    }

    public int maxPowerExtracted() {
        return 1000;
    }

    public int getRf() {
        return this.currentRF;
    }

    @Override
    public boolean isEngineOn() {
        return this.isPumping;
    }

    @Override
    public long getCurrentMjOutput() {
        if (this.currentRF > 0) {
            return this.getMjPerTick();
        }
        return 0L;
    }

    @Override
    public long getMjStored() {
        return this.mjBattery.getStored();
    }

    protected boolean isValidUpgrade(int slot, ItemStack stack) {
        Item item = stack.func_77973_b();
        return TileEngineRF.RF_UPGRADE.containsKey(item);
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack current = player.func_184586_b(hand).func_77946_l();
        if (super.onActivated(player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!current.func_190926_b()) {
            if (EntityUtil.getWrenchHand((EntityLivingBase)player) != null) {
                return false;
            }
            if (current.func_77973_b() instanceof IItemPipe) {
                return false;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            BCEnergyGuis.DYNAMO_MJ.openGUI(player, this.func_174877_v());
        }
        return true;
    }

    public long getMjPerTick() {
        long value = MjAPI.MJ * 4L;
        for (int slot = 0; slot < this.invUpgrades.getSlots(); ++slot) {
            Long add;
            ItemStack stack = this.invUpgrades.getStackInSlot(slot);
            if (stack.func_190926_b() || (add = TileEngineRF.RF_UPGRADE.get(stack.func_77973_b())) == null) continue;
            value += add.longValue();
        }
        return value;
    }

    public int getRfGenerationRate() {
        long mjPerTick = this.getMjPerTick();
        long mjPerRf = BCLibConfig.mjRfConversion.mjPerRf;
        return (int)(mjPerTick / mjPerRf);
    }

    protected void burn() {
        long mjStored = this.mjBattery.getStored();
        if (mjStored <= 0L) {
            return;
        }
        if (this.isRedstonePowered) {
            long mjPerRf = BCLibConfig.mjRfConversion.mjPerRf;
            int genRf = this.getRfGenerationRate();
            int maxRf = (int)Math.min((long)genRf, mjStored / mjPerRf);
            if (maxRf <= 0) {
                return;
            }
            if (this.currentRF + maxRf >= 10000) {
                return;
            }
            if (this.mjBattery.extractPower((long)maxRf * mjPerRf)) {
                this.currentOutput = maxRf;
                this.addPower(maxRf);
                this.heat += 0.06;
                if (this.heat >= 200.0) {
                    this.heat = 200.0;
                }
            }
        }
    }

    public void updateHeatLevel() {
        if (this.heat > 20.0) {
            this.heat -= 0.01;
        }
        if (this.heat <= 20.0) {
            this.heat = 20.0;
        }
        this.getPowerStage();
    }

    public int getCurrentOutput() {
        if (this.currentRF > 0) {
            return (int)(this.getMjPerTick() / BCLibConfig.mjRfConversion.mjPerRf);
        }
        return 0;
    }

    public int getCurrentRF() {
        return this.currentRF;
    }

    public EnumFacing getCurrentDirection() {
        return this.currentDirection;
    }

    @SideOnly(value=Side.CLIENT)
    public float getProgressClient(float partialTicks) {
        float last = this.lastProgress;
        float now = this.progress;
        if ((double)last > 0.5 && (double)now < 0.5) {
            now += 1.0f;
        }
        float interp = last * (1.0f - partialTicks) + now * partialTicks;
        return interp % 1.0f;
    }

    private class Rf
    implements IEnergyStorage {
        private Rf() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if ((maxExtract = Math.min(maxExtract, TileDynamoMJ.this.currentRF)) <= 0) {
                return 0;
            }
            if (!simulate) {
                TileDynamoMJ.this.currentRF -= maxExtract;
            }
            return maxExtract;
        }

        public int getEnergyStored() {
            return TileDynamoMJ.this.currentRF;
        }

        public int getMaxEnergyStored() {
            return 10000;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

