/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.BCModules;
import buildcraft.energy.BCEnergyConfig;
import buildcraft.lib.fluid.BCFluid;
import buildcraft.lib.fluid.BCFluidBlock;
import buildcraft.lib.fluid.FluidManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.MapColor;
import net.minecraft.util.ResourceLocation;

public class BCEnergyFluids {
    public static BCFluid[] crudeOil;
    public static BCFluid[] oilDistilled;
    public static BCFluid[] oilHeavy;
    public static BCFluid[] fuelMixedLight;
    public static BCFluid[] fuelMixedHeavy;
    public static BCFluid[] oilDense;
    public static BCFluid[] fuelGaseous;
    public static BCFluid[] fuelLight;
    public static BCFluid[] fuelDense;
    public static BCFluid[] oilResidue;
    public static BCFluid tar;
    public static final List<BCFluid> allFluids;

    public static void preInit() {
        int[][] data = new int[][]{{900, 2000, 3, 6, 0x505050, 328965, 1, 1}, {1200, 4000, 3, 4, 0x100F10, 4329538, 1, 0}, {850, 1800, 3, 6, 10522399, 4338976, 1, 1}, {950, 1600, 3, 5, 8875639, 0x422424, 1, 1}, {750, 1400, 2, 8, 14987128, 11828992, 0, 1}, {600, 800, 2, 7, 0xFFAF3F, 14712576, 0, 1}, {700, 1000, 2, 7, 15902464, 12879616, 0, 1}, {400, 600, 1, 8, 0xFFFF30, 14995200, 0, 1}, {650, 900, 1, 9, 16176896, 12891904, 0, 1}, {300, 500, 0, 10, 16447024, 14735616, 0, 1}};
        if (BCModules.FACTORY.isLoaded()) {
            int index = 0;
            crudeOil = BCEnergyFluids.defineFluids(data[index++], "oil");
            oilResidue = BCEnergyFluids.defineFluids(data[index++], "oil_residue");
            oilHeavy = BCEnergyFluids.defineFluids(data[index++], "oil_heavy");
            oilDense = BCEnergyFluids.defineFluids(data[index++], "oil_dense");
            oilDistilled = BCEnergyFluids.defineFluids(data[index++], "oil_distilled");
            fuelDense = BCEnergyFluids.defineFluids(data[index++], "fuel_dense");
            fuelMixedHeavy = BCEnergyFluids.defineFluids(data[index++], "fuel_mixed_heavy");
            fuelLight = BCEnergyFluids.defineFluids(data[index++], "fuel_light");
            fuelMixedLight = BCEnergyFluids.defineFluids(data[index++], "fuel_mixed_light");
            fuelGaseous = BCEnergyFluids.defineFluids(data[index++], "fuel_gaseous");
        } else {
            crudeOil = new BCFluid[]{BCEnergyFluids.defineFluid(data[0], 0, "oil")};
            oilResidue = new BCFluid[0];
            oilHeavy = new BCFluid[0];
            oilDense = new BCFluid[0];
            oilDistilled = new BCFluid[0];
            fuelDense = new BCFluid[0];
            fuelMixedHeavy = new BCFluid[0];
            fuelLight = new BCFluid[]{BCEnergyFluids.defineFluid(data[7], 0, "fuel_light")};
            fuelMixedLight = new BCFluid[0];
            fuelGaseous = new BCFluid[0];
        }
    }

    private static BCFluid[] defineFluids(int[] data, String name) {
        BCFluid[] arr = new BCFluid[3];
        for (int h = 0; h < 3; ++h) {
            arr[h] = BCEnergyFluids.defineFluid(data, h, name);
        }
        return arr;
    }

    private static BCFluid defineFluid(int[] data, int heat, String name) {
        boolean sticky;
        int density = data[0];
        int baseViscosity = data[1];
        int boilPoint = data[2];
        int baseQuanta = data[3];
        int texLight = data[4];
        int texDark = data[5];
        boolean bl = sticky = BCEnergyConfig.oilIsSticky && data[6] == 1;
        boolean flammable = BCEnergyConfig.enableOilBurn ? data[7] == 1 : false;
        String fullName = name + (heat == 0 ? "" : "_heat_" + heat);
        int tempAdjustedViscosity = baseViscosity * (4 - heat) / 4;
        int boilAdjustedDensity = density * (heat >= boilPoint ? -1 : 1);
        String fluidTexture = "buildcraftenergy:blocks/fluids/" + name + "_heat_" + heat;
        BCFluid def = new BCFluid(fullName, new ResourceLocation(fluidTexture + "_still"), new ResourceLocation(fluidTexture + "_flow"));
        def.setBlockName(name + "_heat_" + heat);
        def.setMapColour(BCEnergyFluids.getMapColor(texDark));
        def.setFlammable(flammable);
        def.setHeat(heat);
        def.setUnlocalizedName(name);
        def.setTemperature(300 + 20 * heat);
        def.setViscosity(tempAdjustedViscosity);
        def.setDensity(boilAdjustedDensity);
        def.setGaseous(def.getDensity() < 0);
        def.setColour(texLight, texDark);
        def.setHeatable(true);
        FluidManager.register(def);
        BCFluidBlock block = (BCFluidBlock)def.getBlock();
        block.func_149713_g(3);
        block.setSticky(sticky);
        block.setQuantaPerBlock(baseQuanta + (baseQuanta > 6 ? heat : heat / 2));
        allFluids.add(def);
        return def;
    }

    private static MapColor getMapColor(int color) {
        MapColor bestMapColor = MapColor.field_151646_E;
        int currentDifference = Integer.MAX_VALUE;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        for (MapColor mapColor : MapColor.field_76281_a) {
            int mb;
            int db;
            int mg;
            int dg;
            int mr;
            int dr;
            int difference;
            if (mapColor == null || mapColor.field_76291_p == 0 || (difference = (dr = (mr = mapColor.field_76291_p >> 16 & 0xFF) - r) * dr + (dg = (mg = mapColor.field_76291_p >> 8 & 0xFF) - g) * dg + (db = (mb = mapColor.field_76291_p & 0xFF) - b) * db) >= currentDifference) continue;
            currentDifference = difference;
            bestMapColor = mapColor;
        }
        return bestMapColor;
    }

    static {
        allFluids = new ArrayList<BCFluid>();
    }
}

